/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.javascript.internal.ui.JavaScriptUI;
import org.eclipse.dltk.javascript.internal.ui.preferences.JavascriptBuildPathsBlock;
import org.eclipse.dltk.javascript.internal.ui.wizards.JavascriptWizardMessages;
import org.eclipse.dltk.javascript.ui.JavaScriptImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.wizards.BuildpathsBlock;
import org.eclipse.dltk.ui.wizards.NewElementWizard;
import org.eclipse.dltk.ui.wizards.ProjectWizardFirstPage;
import org.eclipse.dltk.ui.wizards.ProjectWizardSecondPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class JavascriptProjectCreationWizard
extends NewElementWizard
implements INewWizard,
IExecutableExtension {
    private ProjectWizardFirstPage fFirstPage;
    private ProjectWizardSecondPage fSecondPage;
    private IConfigurationElement fConfigElement;

    public JavascriptProjectCreationWizard() {
        this.setDefaultPageImageDescriptor(JavaScriptImages.DESC_WIZBAN_PROJECT_CREATION);
        this.setDialogSettings(DLTKUIPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(JavascriptWizardMessages.ProjectCreationWizard_title);
    }

    public void addPages() {
        super.addPages();
        this.fFirstPage = new ProjectWizardFirstPage(){

            protected ProjectWizardFirstPage.IInterpreterGroup createInterpreterGroup(Composite parent) {
                return new JavascriptInterpreterGroup(parent);
            }

            protected boolean interpeterRequired() {
                return false;
            }

            final class JavascriptInterpreterGroup
            extends ProjectWizardFirstPage.AbstractInterpreterGroup {
                public JavascriptInterpreterGroup(Composite composite) {
                    super((ProjectWizardFirstPage)this, composite);
                }

                protected String getCurrentLanguageNature() {
                    return "org.eclipse.dltk.javascript.core.nature";
                }

                protected String getIntereprtersPreferencePageId() {
                    return null;
                }

                protected boolean isTargetEnvironmentAllowed() {
                    return false;
                }
            }
        };
        this.fFirstPage.setTitle(JavascriptWizardMessages.ProjectCreationWizardFirstPage_title);
        this.fFirstPage.setDescription(JavascriptWizardMessages.ProjectCreationWizardFirstPage_description);
        this.addPage((IWizardPage)this.fFirstPage);
        this.fSecondPage = new ProjectWizardSecondPage(this.fFirstPage){

            protected BuildpathsBlock createBuildpathBlock(IStatusChangeListener listener) {
                return new JavascriptBuildPathsBlock((IRunnableContext)new BusyIndicatorRunnableContext(), listener, 0, this.useNewSourcePage(), null);
            }

            protected String getScriptNature() {
                return "org.eclipse.dltk.javascript.core.nature";
            }

            protected IPreferenceStore getPreferenceStore() {
                return JavaScriptUI.getDefault().getPreferenceStore();
            }
        };
        this.addPage((IWizardPage)this.fSecondPage);
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fSecondPage.performFinish(monitor);
    }

    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            this.selectAndReveal((IResource)this.fSecondPage.getScriptProject().getProject());
        }
        return res;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    public boolean performCancel() {
        this.fSecondPage.performCancel();
        return super.performCancel();
    }

    public IModelElement getCreatedElement() {
        return DLTKCore.create((IProject)this.fFirstPage.getProjectHandle());
    }
}

