/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.net.URI;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.dbgp.IDbgpSession;
import org.eclipse.dltk.dbgp.IDbgpSpawnpoint;
import org.eclipse.dltk.dbgp.breakpoints.DbgpBreakpointConfig;
import org.eclipse.dltk.dbgp.commands.IDbgpCoreCommands;
import org.eclipse.dltk.dbgp.commands.IDbgpSpawnpointCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.DebugOption;
import org.eclipse.dltk.debug.core.IDLTKDebugToolkit;
import org.eclipse.dltk.debug.core.ScriptDebugManager;
import org.eclipse.dltk.debug.core.model.IScriptBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptBreakpointPathMapper;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptExceptionBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptLineBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptMethodEntryBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptSpawnpoint;
import org.eclipse.dltk.debug.core.model.IScriptWatchpoint;
import org.eclipse.dltk.internal.debug.core.model.IScriptBreakpointPathMapperExtension;
import org.eclipse.dltk.internal.debug.core.model.Messages;
import org.eclipse.dltk.internal.debug.core.model.ScriptBreakpointUtils;
import org.eclipse.dltk.internal.debug.core.model.StrUtils;
import org.eclipse.osgi.util.NLS;

public class ScriptBreakpointManager
implements IBreakpointListener,
IBreakpointManagerListener {
    final IScriptBreakpointPathMapper bpPathMapper;
    private static final IDbgpSession[] NO_SESSIONS = new IDbgpSession[0];
    private IDbgpSession[] sessions;
    private static final int NO_CHANGES = 0;
    private static final int MINOR_CHANGE = 1;
    private static final int MAJOR_CHANGE = 2;
    private final IScriptDebugTarget target;
    static /* synthetic */ Class class$0;

    protected static IBreakpointManager getBreakpointManager() {
        return DebugPlugin.getDefault().getBreakpointManager();
    }

    protected static DbgpBreakpointConfig createBreakpointConfig(IScriptBreakpoint breakpoint) throws CoreException {
        boolean enabled = breakpoint.isEnabled() && ScriptBreakpointManager.getBreakpointManager().isEnabled();
        DbgpBreakpointConfig config = new DbgpBreakpointConfig(enabled);
        config.setHitValue(breakpoint.getHitValue());
        config.setHitCondition(breakpoint.getHitCondition());
        if (breakpoint.getExpressionState()) {
            config.setExpression(breakpoint.getExpression());
        }
        if (breakpoint instanceof IScriptLineBreakpoint && !(breakpoint instanceof IScriptMethodEntryBreakpoint)) {
            IScriptLineBreakpoint lineBreakpoint = (IScriptLineBreakpoint)breakpoint;
            config.setLineNo(lineBreakpoint.getLineNumber());
        }
        return config;
    }

    protected static String makeWatchpointExpression(IScriptWatchpoint watchpoint) throws CoreException {
        IDLTKDebugToolkit debugToolkit = ScriptDebugManager.getInstance().getDebugToolkitByDebugModel(watchpoint.getModelIdentifier());
        if (debugToolkit.isAccessWatchpointSupported()) {
            return String.valueOf(watchpoint.getFieldName()) + (watchpoint.isAccess() ? (char)'1' : '0') + (watchpoint.isModification() ? (char)'1' : '0');
        }
        return watchpoint.getFieldName();
    }

    protected void addBreakpoint(IDbgpSession session, IScriptBreakpoint breakpoint) throws CoreException, DbgpException {
        IScriptBreakpoint lineBreakpoint;
        IDbgpCoreCommands commands = session.getCoreCommands();
        DbgpBreakpointConfig config = ScriptBreakpointManager.createBreakpointConfig(breakpoint);
        String id = null;
        URI bpUri = null;
        if (breakpoint instanceof IScriptLineBreakpoint) {
            IScriptLineBreakpoint bp = (IScriptLineBreakpoint)breakpoint;
            bpUri = this.bpPathMapper.map(bp.getResourceURI());
        }
        if (breakpoint instanceof IScriptWatchpoint) {
            IScriptWatchpoint watchpoint = (IScriptWatchpoint)breakpoint;
            config.setExpression(ScriptBreakpointManager.makeWatchpointExpression(watchpoint));
            id = commands.setWatchBreakpoint(bpUri, watchpoint.getLineNumber(), config);
        } else if (breakpoint instanceof IScriptMethodEntryBreakpoint) {
            IScriptMethodEntryBreakpoint entryBreakpoint = (IScriptMethodEntryBreakpoint)breakpoint;
            if (entryBreakpoint.breakOnExit()) {
                String exitId = commands.setReturnBreakpoint(bpUri, entryBreakpoint.getMethodName(), config);
                entryBreakpoint.setExitBreakpointId(exitId);
            }
            if (entryBreakpoint.breakOnEntry()) {
                String entryId = commands.setCallBreakpoint(bpUri, entryBreakpoint.getMethodName(), config);
                entryBreakpoint.setEntryBreakpointId(entryId);
            }
        } else if (breakpoint instanceof IScriptLineBreakpoint) {
            lineBreakpoint = (IScriptLineBreakpoint)breakpoint;
            id = ScriptBreakpointUtils.isConditional(lineBreakpoint) ? commands.setConditionalBreakpoint(bpUri, lineBreakpoint.getLineNumber(), config) : commands.setLineBreakpoint(bpUri, lineBreakpoint.getLineNumber(), config);
        } else if (breakpoint instanceof IScriptExceptionBreakpoint) {
            lineBreakpoint = (IScriptExceptionBreakpoint)breakpoint;
            id = commands.setExceptionBreakpoint(lineBreakpoint.getTypeName(), config);
        }
        breakpoint.setId(session, id);
    }

    private void addSpawnpoint(IDbgpSession session, IScriptSpawnpoint spawnpoint) throws DbgpException, CoreException {
        IDbgpSpawnpointCommands commands;
        IDbgpSpawnpoint p;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.dbgp.commands.IDbgpSpawnpointCommands");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((p = (commands = (IDbgpSpawnpointCommands)session.get(clazz)).setSpawnpoint(this.bpPathMapper.map(spawnpoint.getResourceURI()), spawnpoint.getLineNumber(), spawnpoint.isEnabled())) != null) {
            spawnpoint.setId(session, p.getId());
        }
    }

    protected void changeBreakpoint(IDbgpSession session, IScriptBreakpoint breakpoint) throws DbgpException, CoreException {
        IDbgpCoreCommands commands = session.getCoreCommands();
        URI bpUri = null;
        if (breakpoint instanceof IScriptLineBreakpoint) {
            IScriptLineBreakpoint bp = (IScriptLineBreakpoint)breakpoint;
            bpUri = this.bpPathMapper.map(bp.getResourceURI());
        }
        if (breakpoint instanceof IScriptMethodEntryBreakpoint) {
            DbgpBreakpointConfig config = ScriptBreakpointManager.createBreakpointConfig(breakpoint);
            IScriptMethodEntryBreakpoint entryBreakpoint = (IScriptMethodEntryBreakpoint)breakpoint;
            String entryId = entryBreakpoint.getEntryBreakpointId();
            if (entryBreakpoint.breakOnEntry()) {
                if (entryId == null) {
                    entryId = commands.setCallBreakpoint(bpUri, entryBreakpoint.getMethodName(), config);
                    entryBreakpoint.setEntryBreakpointId(entryId);
                } else {
                    commands.updateBreakpoint(entryId, config);
                }
            } else if (entryId != null) {
                commands.removeBreakpoint(entryId);
                entryBreakpoint.setEntryBreakpointId(null);
            }
            String exitId = entryBreakpoint.getExitBreakpointId();
            if (entryBreakpoint.breakOnExit()) {
                if (exitId == null) {
                    exitId = commands.setReturnBreakpoint(bpUri, entryBreakpoint.getMethodName(), config);
                    entryBreakpoint.setExitBreakpointId(exitId);
                } else {
                    commands.updateBreakpoint(exitId, config);
                }
            } else if (exitId != null) {
                commands.removeBreakpoint(exitId);
                entryBreakpoint.setExitBreakpointId(null);
            }
        } else {
            String id = breakpoint.getId(session);
            if (id != null) {
                DbgpBreakpointConfig config = ScriptBreakpointManager.createBreakpointConfig(breakpoint);
                if (breakpoint instanceof IScriptWatchpoint) {
                    config.setExpression(ScriptBreakpointManager.makeWatchpointExpression((IScriptWatchpoint)breakpoint));
                }
                commands.updateBreakpoint(id, config);
            }
        }
    }

    protected static void removeBreakpoint(IDbgpSession session, IScriptBreakpoint breakpoint) throws DbgpException, CoreException {
        IDbgpCoreCommands commands = session.getCoreCommands();
        String id = breakpoint.removeId(session);
        if (id != null) {
            commands.removeBreakpoint(id);
        }
        if (breakpoint instanceof IScriptMethodEntryBreakpoint) {
            String exitId;
            IScriptMethodEntryBreakpoint entryBreakpoint = (IScriptMethodEntryBreakpoint)breakpoint;
            String entryId = entryBreakpoint.getEntryBreakpointId();
            if (entryId != null) {
                commands.removeBreakpoint(entryId);
            }
            if ((exitId = entryBreakpoint.getExitBreakpointId()) != null) {
                commands.removeBreakpoint(exitId);
            }
        }
    }

    private int hasBreakpointChanges(IMarkerDelta delta, IScriptBreakpoint breakpoint) {
        String[] attrs = breakpoint.getUpdatableAttributes();
        try {
            IMarker marker = delta.getMarker();
            int i = 0;
            while (i < attrs.length) {
                String attr = attrs[i];
                Object oldValue = delta.getAttribute(attr);
                Object newValue = marker.getAttribute(attr);
                if (oldValue == null) {
                    if (newValue != null) {
                        return this.classifyBreakpointChange(delta, breakpoint, attr);
                    }
                } else {
                    if (newValue == null) {
                        return this.classifyBreakpointChange(delta, breakpoint, attr);
                    }
                    if (!oldValue.equals(newValue)) {
                        return this.classifyBreakpointChange(delta, breakpoint, attr);
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            DLTKDebugPlugin.log(e);
        }
        return 0;
    }

    private static int hasSpawnpointChanges(IMarkerDelta delta, IScriptBreakpoint breakpoint) {
        String[] attrs = breakpoint.getUpdatableAttributes();
        try {
            IMarker marker = delta.getMarker();
            int i = 0;
            while (i < attrs.length) {
                String attr = attrs[i];
                if ("org.eclipse.debug.core.enabled".equals(attr) || "lineNumber".equals(attr)) {
                    Object oldValue = delta.getAttribute(attr);
                    Object newValue = marker.getAttribute(attr);
                    if (oldValue == null) {
                        if (newValue != null) {
                            return "lineNumber".equals(attr) ? 2 : 1;
                        }
                    } else {
                        if (newValue == null) {
                            return "lineNumber".equals(attr) ? 2 : 1;
                        }
                        if (!oldValue.equals(newValue)) {
                            return "lineNumber".equals(attr) ? 2 : 1;
                        }
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            DLTKDebugPlugin.log(e);
        }
        return 0;
    }

    private int classifyBreakpointChange(IMarkerDelta delta, IScriptBreakpoint breakpoint, String attr) throws CoreException {
        String oldExpr;
        boolean conditional = ScriptBreakpointUtils.isConditional(breakpoint);
        if (conditional && "org.eclipse.dltk.debug.expression".equals(attr)) {
            return 2;
        }
        boolean oldExprState = delta.getAttribute("org.eclipse.dltk.debug.expression.state", false);
        if (ScriptBreakpointUtils.isConditional(oldExprState, oldExpr = delta.getAttribute("org.eclipse.dltk.debug.expression", null)) != conditional) {
            return 2;
        }
        if ("lineNumber".equals(attr) && !this.target.getOptions().get(DebugOption.DBGP_BREAKPOINT_UPDATE_LINE_NUMBER)) {
            return 2;
        }
        return 1;
    }

    private void changeSpawnpoint(IDbgpSession session, IScriptSpawnpoint spawnpoint) throws DbgpException, CoreException {
        String id;
        IDbgpSpawnpointCommands commands;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.dbgp.commands.IDbgpSpawnpointCommands");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((commands = (IDbgpSpawnpointCommands)session.get(clazz)) != null && (id = spawnpoint.getId(session)) != null) {
            commands.updateSpawnpoint(id, spawnpoint.isEnabled());
        }
    }

    protected void removeSpawnpoint(IDbgpSession session, IScriptSpawnpoint spawnpoint) throws DbgpException, CoreException {
        String id;
        IDbgpSpawnpointCommands commands;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.dbgp.commands.IDbgpSpawnpointCommands");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((commands = (IDbgpSpawnpointCommands)session.get(clazz)) != null && (id = spawnpoint.getId(session)) != null) {
            commands.removeSpawnpoint(id);
            spawnpoint.setId(session, null);
        }
    }

    public ScriptBreakpointManager(IScriptDebugTarget target, IScriptBreakpointPathMapper pathMapper) {
        this.target = target;
        this.bpPathMapper = pathMapper;
        this.sessions = NO_SESSIONS;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        if (breakpoint instanceof IScriptBreakpoint) {
            return StrUtils.equals(breakpoint.getModelIdentifier(), this.target.getModelIdentifier());
        }
        return false;
    }

    private void threadAccepted() {
        IBreakpointManager manager = ScriptBreakpointManager.getBreakpointManager();
        manager.addBreakpointListener((IBreakpointListener)this.target);
        manager.addBreakpointManagerListener((IBreakpointManagerListener)this);
    }

    public void threadTerminated() {
        IBreakpointManager manager = ScriptBreakpointManager.getBreakpointManager();
        manager.removeBreakpointListener((IBreakpointListener)this.target);
        manager.removeBreakpointManagerListener((IBreakpointManagerListener)this);
        if (this.bpPathMapper instanceof IScriptBreakpointPathMapperExtension) {
            ((IScriptBreakpointPathMapperExtension)this.bpPathMapper).clearCache();
        }
    }

    synchronized IDbgpSession[] getSessions() {
        return this.sessions;
    }

    private synchronized boolean addSession(IDbgpSession session) {
        int i = 0;
        while (i < this.sessions.length) {
            if (session.equals(this.sessions[i])) {
                return false;
            }
            ++i;
        }
        IDbgpSession[] temp = new IDbgpSession[this.sessions.length + 1];
        System.arraycopy(this.sessions, 0, temp, 0, this.sessions.length);
        temp[this.sessions.length] = session;
        this.sessions = temp;
        return true;
    }

    synchronized boolean removeSession(IDbgpSession session) {
        int i = 0;
        while (i < this.sessions.length) {
            if (session.equals(this.sessions[i])) {
                if (this.sessions.length == 1) {
                    this.sessions = NO_SESSIONS;
                } else {
                    IDbgpSession[] temp = new IDbgpSession[this.sessions.length - 1];
                    if (i > 0) {
                        System.arraycopy(this.sessions, 0, temp, 0, i);
                    }
                    if (++i < this.sessions.length) {
                        System.arraycopy(this.sessions, i, temp, i - 1, this.sessions.length - i);
                    }
                    this.sessions = temp;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public void initializeSession(IDbgpSession session, IProgressMonitor monitor) {
        if (!this.addSession(session)) {
            return;
        }
        IBreakpoint[] breakpoints = ScriptBreakpointManager.getBreakpointManager().getBreakpoints(this.target.getModelIdentifier());
        monitor.beginTask("", breakpoints.length);
        int i = 0;
        while (i < breakpoints.length) {
            block6: {
                try {
                    IBreakpoint breakpoint = breakpoints[i];
                    if (breakpoint instanceof IScriptSpawnpoint) {
                        this.addSpawnpoint(session, (IScriptSpawnpoint)breakpoint);
                    } else {
                        this.addBreakpoint(session, (IScriptBreakpoint)breakpoint);
                    }
                }
                catch (Exception e) {
                    DLTKDebugPlugin.logWarning(NLS.bind((String)Messages.ErrorSetupDeferredBreakpoints, (Object)e.getMessage()), e);
                    if (!DLTKCore.DEBUG) break block6;
                    e.printStackTrace();
                }
            }
            monitor.worked(1);
            ++i;
        }
        this.threadAccepted();
        monitor.done();
    }

    public void setBreakpointUntilFirstSuspend(URI uri, int line) {
        TemporaryBreakpoint temp = new TemporaryBreakpoint(this, uri, line);
        if (!temp.ids.isEmpty()) {
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)temp);
        }
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (!this.supportsBreakpoint(breakpoint)) {
            return;
        }
        try {
            IDbgpSession[] sessions = this.getSessions();
            int i = 0;
            while (i < sessions.length) {
                if (breakpoint instanceof IScriptSpawnpoint) {
                    this.addSpawnpoint(sessions[i], (IScriptSpawnpoint)breakpoint);
                } else {
                    this.addBreakpoint(sessions[i], (IScriptBreakpoint)breakpoint);
                }
                ++i;
            }
        }
        catch (Exception e) {
            DLTKDebugPlugin.log(e);
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (!this.supportsBreakpoint(breakpoint)) {
            return;
        }
        try {
            if (breakpoint instanceof IScriptSpawnpoint) {
                int changes;
                int n = changes = delta != null ? ScriptBreakpointManager.hasSpawnpointChanges(delta, (IScriptSpawnpoint)breakpoint) : 2;
                if (changes != 0) {
                    IDbgpSession[] sessions = this.getSessions();
                    if (changes == 2) {
                        int i = 0;
                        while (i < sessions.length) {
                            this.removeSpawnpoint(sessions[i], (IScriptSpawnpoint)breakpoint);
                            this.addSpawnpoint(sessions[i], (IScriptSpawnpoint)breakpoint);
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < sessions.length) {
                            this.changeSpawnpoint(sessions[i], (IScriptSpawnpoint)breakpoint);
                            ++i;
                        }
                    }
                }
            } else {
                int changes;
                IScriptBreakpoint sbp = (IScriptBreakpoint)breakpoint;
                int n = changes = delta != null ? this.hasBreakpointChanges(delta, sbp) : 2;
                if (changes != 0) {
                    IDbgpSession[] sessions = this.getSessions();
                    if (changes == 2) {
                        int i = 0;
                        while (i < sessions.length) {
                            ScriptBreakpointManager.removeBreakpoint(sessions[i], sbp);
                            this.addBreakpoint(sessions[i], sbp);
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < sessions.length) {
                            this.changeBreakpoint(sessions[i], sbp);
                            ++i;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            DLTKDebugPlugin.log(e);
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (!this.supportsBreakpoint(breakpoint)) {
            return;
        }
        try {
            IDbgpSession[] sessions = this.getSessions();
            if (breakpoint instanceof IScriptSpawnpoint) {
                int i = 0;
                while (i < sessions.length) {
                    this.removeSpawnpoint(sessions[i], (IScriptSpawnpoint)breakpoint);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < sessions.length) {
                    ScriptBreakpointManager.removeBreakpoint(sessions[i], (IScriptBreakpoint)breakpoint);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            DLTKDebugPlugin.log(e);
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        IBreakpoint[] breakpoints = ScriptBreakpointManager.getBreakpointManager().getBreakpoints(this.target.getModelIdentifier());
        IDbgpSession[] sessions = this.getSessions();
        int i = 0;
        while (i < breakpoints.length) {
            try {
                int j;
                IBreakpoint breakpoint = breakpoints[i];
                if (breakpoint instanceof IScriptSpawnpoint) {
                    j = 0;
                    while (j < sessions.length) {
                        this.changeSpawnpoint(sessions[j], (IScriptSpawnpoint)breakpoint);
                        ++j;
                    }
                } else if (breakpoint instanceof IScriptBreakpoint) {
                    j = 0;
                    while (j < sessions.length) {
                        this.changeBreakpoint(sessions[j], (IScriptBreakpoint)breakpoint);
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                DLTKDebugPlugin.log(e);
            }
            ++i;
        }
    }

    private static class TemporaryBreakpoint
    implements IDebugEventSetListener {
        final ScriptBreakpointManager manager;
        final Map ids = new IdentityHashMap(1);

        public TemporaryBreakpoint(ScriptBreakpointManager manager, URI uri, int line) {
            this.manager = manager;
            IDbgpSession[] sessions = manager.getSessions();
            int i = 0;
            while (i < sessions.length) {
                DbgpBreakpointConfig config = new DbgpBreakpointConfig(true);
                try {
                    String id = sessions[i].getCoreCommands().setLineBreakpoint(uri, line, config);
                    if (id != null) {
                        this.ids.put(sessions[i], id);
                    }
                }
                catch (DbgpException e) {
                    DLTKDebugPlugin.log(e);
                }
                ++i;
            }
        }

        public void handleDebugEvents(DebugEvent[] events) {
            int i = 0;
            while (i < events.length) {
                DebugEvent event = events[i];
                if (event.getKind() == 2) {
                    this.removeBreakpoint();
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    break;
                }
                ++i;
            }
        }

        private void removeBreakpoint() {
            try {
                IDbgpSession[] sessions = this.manager.getSessions();
                int i = 0;
                while (i < sessions.length) {
                    IDbgpSession session = sessions[i];
                    String id = (String)this.ids.remove(session);
                    if (id != null) {
                        session.getCoreCommands().removeBreakpoint(id);
                    }
                    ++i;
                }
            }
            catch (DbgpException e) {
                DLTKDebugPlugin.log(e);
            }
        }
    }
}

