/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.Expression;

public class PropertyExpression
extends Expression {
    private Expression object;
    private Expression property;
    private int dot = -1;

    public PropertyExpression(ASTNode parent) {
        super(parent);
    }

    public Expression getObject() {
        return this.object;
    }

    public void setObject(Expression object) {
        this.object = object;
    }

    public Expression getProperty() {
        return this.property;
    }

    public void setProperty(Expression property) {
        this.property = property;
    }

    public int getDotPosition() {
        return this.dot;
    }

    public void setDotPosition(int dot) {
        this.dot = dot;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.dot > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.object.toSourceString(indentationString));
        buffer.append('.');
        buffer.append(this.property.toSourceString(indentationString));
        return buffer.toString();
    }

    public boolean isBlock() {
        return false;
    }
}

