/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.launching;

import com.xored.org.mozilla.javascript.BaseFunction;
import com.xored.org.mozilla.javascript.Context;
import com.xored.org.mozilla.javascript.Function;
import com.xored.org.mozilla.javascript.IdScriptableObject;
import com.xored.org.mozilla.javascript.NativeFunction;
import com.xored.org.mozilla.javascript.Scriptable;
import com.xored.org.mozilla.javascript.ScriptableObject;
import com.xored.org.mozilla.javascript.SimpleIntrospector;
import com.xored.org.mozilla.javascript.Undefined;
import com.xored.org.mozilla.javascript.UniqueTag;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class BuiltinsResolver {
    static String init = BuiltinsResolver.init();
    private static Context enter;
    private static ScriptableObject initStandardObjects;
    static /* synthetic */ Class class$0;

    public static String init() {
        StringBuffer buf = new StringBuffer();
        enter = Context.enter();
        initStandardObjects = enter.initStandardObjects();
        Object[] allIds = initStandardObjects.getAllIds();
        int a = 0;
        while (a < allIds.length) {
            String string = allIds[a].toString();
            try {
                string.equals("XML");
                Object object = initStandardObjects.get(string, (Scriptable)initStandardObjects);
                BuiltinsResolver.appendObject(buf, string, object);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++a;
        }
        return buf.toString();
    }

    private static void appendObject(StringBuffer buf, String string, Object object) {
        if (object instanceof Function) {
            String[] args = new String[]{};
            Function c = (Function)object;
            String name = "";
            c.get("arguments", (Scriptable)c);
            if (c instanceof NativeFunction) {
                NativeFunction function = (NativeFunction)c;
                args = SimpleIntrospector.getParameterNames((NativeFunction)function);
                function.getFunctionName();
            }
            if (c instanceof BaseFunction) {
                name = ((BaseFunction)c).getFunctionName();
            }
            BuiltinsResolver.appendFunction(buf, name, args, c);
            if (!name.equals(string)) {
                BuiltinsResolver.appendFunction(buf, string, args, c);
            }
        } else {
            if (object instanceof UniqueTag) {
                return;
            }
            if (object instanceof Undefined) {
                return;
            }
            if (object instanceof ScriptableObject) {
                BuiltinsResolver.appendObject(buf, string, (ScriptableObject)object);
            }
        }
    }

    public static void appendFunction(StringBuffer buf, String name, String[] argNames, Function c) {
        ScriptableObject cfr_ignored_0 = (ScriptableObject)c;
        buf.append("function " + name + "(");
        int a = 0;
        while (a < argNames.length) {
            buf.append(argNames[a]);
            if (a != argNames.length - 1) {
                buf.append(',');
            }
            ++a;
        }
        buf.append(')');
        buf.append("{");
        if (c != null) {
            try {
                ScriptableObject construct = (ScriptableObject)c.construct(enter, (Scriptable)c, new Object[]{"<xml></xml>"});
                if (construct instanceof IdScriptableObject) {
                    IdScriptableObject sc = (IdScriptableObject)construct;
                    Class<?> class1 = sc.getClass();
                    Method initMethod = null;
                    while (class1 != null) {
                        try {
                            initMethod = class1.getDeclaredMethod("initPrototypeId", Integer.TYPE);
                            initMethod.setAccessible(true);
                            break;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            class1 = class1.getSuperclass();
                        }
                    }
                    class1 = sc.getClass();
                    while (class1 != null) {
                        Field[] declaredFields = class1.getDeclaredFields();
                        int a2 = 0;
                        while (a2 < declaredFields.length) {
                            Field field = declaredFields[a2];
                            field.setAccessible(true);
                            field.get(sc);
                            String name2 = field.getName();
                            if (name2.startsWith("Id_")) {
                                String string = name2 = name2.substring(3);
                                BuiltinsResolver.appendObjects(buf, (ScriptableObject)sc, new String[]{string}, true);
                                BuiltinsResolver.appendFunction(buf, string, new String[0], null);
                            }
                            ++a2;
                        }
                        class1 = class1.getSuperclass();
                    }
                }
                if (construct != null) {
                    Scriptable classPrototype = ScriptableObject.getClassPrototype((Scriptable)c, (String)construct.getClassName());
                    Object[] elements = construct.getAllIds();
                    BuiltinsResolver.appendObjects(buf, construct, elements, false);
                    Object[] cpObjects = ScriptableObject.getPropertyIds((Scriptable)construct);
                    BuiltinsResolver.appendObjects(buf, (ScriptableObject)classPrototype, cpObjects, false);
                }
                Object[] members = ((ScriptableObject)c).getAllIds();
                BuiltinsResolver.appendObjects(buf, (ScriptableObject)c, members, false);
            }
            catch (Exception exception) {}
        }
        buf.append("/* Native built in function*/}\n");
    }

    private static void appendObjects(StringBuffer buf, ScriptableObject construct, Object[] elements, boolean funcs) {
        int a = 0;
        while (a < elements.length) {
            String val;
            String string = elements[a].toString();
            Object object2 = construct.get(string, (Scriptable)construct);
            String string2 = val = funcs ? "function (){};" : "1;";
            if (object2 instanceof Function) {
                val = "function (){};";
            }
            if (object2 instanceof String) {
                val = "function (){};";
            }
            buf.append("this." + string + "=");
            buf.append(val);
            buf.append("\n");
            ++a;
        }
    }

    public static void appendObject(StringBuffer buf, String name, ScriptableObject scriptableObject) {
        buf.append("var " + name + "={");
        ScriptableObject sc = scriptableObject;
        Object[] allIds2 = sc.getAllIds();
        int a = 0;
        while (a < allIds2.length) {
            Object object = allIds2[a];
            Object object2 = sc.get(allIds2[a].toString(), (Scriptable)sc);
            String value = "1";
            if (object2 instanceof Function) {
                value = "function(){}";
            }
            buf.append(String.valueOf(object.toString()) + ":" + value);
            if (a != allIds2.length - 1) {
                buf.append(",");
            }
            buf.append('\n');
            ++a;
        }
        buf.append("};\n");
    }

    public static void main(String[] args) {
        String init2 = BuiltinsResolver.init();
        try {
            FileOutputStream ds = new FileOutputStream("C:/ss");
            PrintStream st = new PrintStream(ds);
            st.println(init2);
            st.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

