/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.core.search;

import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.ISearchPatternProcessor;

public class RubySearchPatternProcessor
implements ISearchPatternProcessor {
    private static final String TYPE_DELIMITER = "::";
    private static final String METHOD_DELIMITER = "::";

    public char[] extractDeclaringTypeQualification(String pattern) {
        int pos = pattern.lastIndexOf("::");
        if (pos != -1) {
            String type = pattern.substring(0, pos);
            return this.extractTypeQualification(type);
        }
        return null;
    }

    public char[] extractDeclaringTypeSimpleName(String pattern) {
        int pos = pattern.lastIndexOf("::");
        if (pos != -1) {
            String type = pattern.substring(0, pos);
            return this.extractTypeChars(type).toCharArray();
        }
        return null;
    }

    public char[] extractSelector(String pattern) {
        int begin;
        int pos = pattern.lastIndexOf("::");
        if (pos != -1 && (begin = pos + "::".length()) < pattern.length()) {
            char[] result = new char[pattern.length() - begin];
            pattern.getChars(begin, pattern.length(), result, 0);
            return result;
        }
        return pattern.toCharArray();
    }

    public String extractTypeChars(String pattern) {
        int begin;
        int pos = pattern.lastIndexOf("::");
        if (pos != -1 && (begin = pos + "::".length()) < pattern.length()) {
            return pattern.substring(begin);
        }
        return pattern;
    }

    public char[] extractTypeQualification(String pattern) {
        int pos = pattern.lastIndexOf("::");
        if (pos != -1) {
            char[] result = new char[pos];
            pattern.getChars(0, pos, result, 0);
            return CharOperation.replace((char[])result, (char[])"::".toCharArray(), (char[])new char[]{'$'});
        }
        return null;
    }

    public String getDelimiterReplacementString() {
        return "::";
    }
}

