/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.folding;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ui.preferences.FieldValidators;
import org.eclipse.dltk.ui.preferences.ImprovedAbstractConfigurationBlock;
import org.eclipse.dltk.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.dltk.ui.text.folding.DocumentationFoldingPreferenceBlock;
import org.eclipse.dltk.ui.text.folding.IFoldingPreferenceBlock;
import org.eclipse.dltk.ui.text.folding.SourceCodeFoldingPreferenceBlock;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class DefaultFoldingPreferenceConfigurationBlock
extends ImprovedAbstractConfigurationBlock {
    private static int DEFAULT_MIN_LINES = 2;
    private IFoldingPreferenceBlock documentationBlock;
    private IFoldingPreferenceBlock sourceCodeBlock;

    public DefaultFoldingPreferenceConfigurationBlock(OverlayPreferenceStore store, PreferencePage page) {
        super(store, page);
        this.documentationBlock = this.createDocumentationBlock(store, page);
        this.sourceCodeBlock = this.createSourceCodeBlock(store, page);
    }

    public Control createControl(Composite parent) {
        Composite composite = SWTFactory.createComposite(parent, parent.getFont(), 1, 1, 4);
        Button enableFolding = SWTFactory.createCheckButton(composite, PreferencesMessages.FoldingConfigurationBlock_enable);
        Text minLines = this.createMinLines(composite);
        TabFolder tabFolder = new TabFolder(composite, 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem comments = new TabItem(tabFolder, 0);
        comments.setText(PreferencesMessages.FoldingConfigurationBlock_docTabName);
        comments.setControl(this.documentationBlock.createControl((Composite)tabFolder));
        if (this.sourceCodeBlock != null) {
            TabItem blocks = new TabItem(tabFolder, 0);
            blocks.setText(PreferencesMessages.FoldingConfigurationBlock_srcTabName);
            blocks.setControl(this.sourceCodeBlock.createControl((Composite)tabFolder));
        }
        this.bindControl(enableFolding, "editor_folding_enabled", new Control[]{minLines, tabFolder});
        this.createAdditionalTabs(tabFolder);
        return composite;
    }

    public void dispose() {
        this.documentationBlock.dispose();
        if (this.sourceCodeBlock != null) {
            this.sourceCodeBlock.dispose();
        }
    }

    protected void createAdditionalTabs(TabFolder tabFolder) {
    }

    protected IFoldingPreferenceBlock createDocumentationBlock(OverlayPreferenceStore store, PreferencePage page) {
        return new DocumentationFoldingPreferenceBlock(store, page);
    }

    protected List createOverlayKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> keys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_enabled"));
        keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "editor_folding_lines_limit"));
        return keys;
    }

    protected IFoldingPreferenceBlock createSourceCodeBlock(OverlayPreferenceStore store, PreferencePage page) {
        return new SourceCodeFoldingPreferenceBlock(store, page);
    }

    protected int defaultMinLines() {
        return DEFAULT_MIN_LINES;
    }

    protected void initializeFields() {
        super.initializeFields();
        this.documentationBlock.initialize();
        if (this.sourceCodeBlock != null) {
            this.sourceCodeBlock.initialize();
        }
    }

    private Text createMinLines(Composite parent) {
        Composite composite = SWTFactory.createComposite(parent, parent.getFont(), 2, 1, 4);
        ((GridLayout)composite.getLayout()).marginWidth = 0;
        int minLines = this.defaultMinLines();
        SWTFactory.createLabel(composite, NLS.bind((String)PreferencesMessages.FoldingConfigurationBlock_minLinesToEnableFolding, (Object)new Integer(minLines)), 0, 1);
        Text textBox = SWTFactory.createText(composite, 2048, 1, "");
        textBox.setTextLimit(4);
        ((GridData)textBox.getLayoutData()).widthHint = new PixelConverter((Control)composite).convertWidthInCharsToPixels(5);
        this.bindControl(textBox, "editor_folding_lines_limit", new FieldValidators.MinimumNumberValidator(minLines));
        return textBox;
    }
}

