/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.parser;

import java.io.CharArrayReader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.FakeModuleDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.parser.AbstractSourceParser;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.compiler.problem.AbstractProblemReporter;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.ruby.ast.RubyClassDeclaration;
import org.eclipse.dltk.ruby.ast.RubyModuleDeclaration;
import org.eclipse.dltk.ruby.core.utils.RubySyntaxUtils;
import org.eclipse.dltk.ruby.internal.parser.RubySourceFixer;
import org.eclipse.dltk.ruby.internal.parser.RubySpacedParensFixer;
import org.eclipse.dltk.ruby.internal.parsers.jruby.DLTKRubyParser;
import org.eclipse.dltk.ruby.internal.parsers.jruby.RubyASTBuildVisitor;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.parser.RubyParserResult;

public class JRubySourceParser
extends AbstractSourceParser {
    private static boolean silentState = true;
    private static final boolean TRACE_AST_JRUBY = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.dltk.core/traceAST/jruby"));
    private static final boolean TRACE_AST_DLTK = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.dltk.core/traceAST/dltk"));
    private final boolean[] errorState = new boolean[1];
    private RubyParserResult parserResult;

    public static boolean isSilentState() {
        return silentState;
    }

    public static void setSilentState(boolean s) {
        silentState = s;
    }

    public RubyParserResult getParserResult() {
        return this.parserResult;
    }

    protected NodeVisitor getASTBuilderVisitor(ModuleDeclaration module, char[] content) {
        return new RubyASTBuildVisitor(module, content);
    }

    public ModuleDeclaration parse(char[] fileName, char[] content, IProblemReporter reporter) {
        try {
            Node node;
            DLTKRubyParser parser = new DLTKRubyParser();
            ProxyProblemReporter proxyProblemReporter = new ProxyProblemReporter(reporter);
            this.errorState[0] = false;
            long sTime = TRACE_AST_DLTK ? System.currentTimeMillis() : 0L;
            final String strFileName = fileName != null ? String.valueOf(fileName) : "";
            char[] fixedContent = RubySpacedParensFixer.fixSpacedParens(content);
            if (!Arrays.equals(fixedContent, content)) {
                parser.parse(strFileName, new CharArrayReader(content), (IProblemReporter)proxyProblemReporter);
                node = parser.parse(strFileName, new CharArrayReader(fixedContent), null);
            } else {
                node = parser.parse(strFileName, new CharArrayReader(content), (IProblemReporter)proxyProblemReporter);
            }
            RubySourceFixer fixer = new RubySourceFixer();
            if (!parser.isSuccess() || this.errorState[0]) {
                String content2 = fixer.fix1(String.valueOf(fixedContent));
                Node node2 = parser.parse(strFileName, new StringReader(content2), null);
                if (node2 != null) {
                    node = node2;
                } else {
                    fixer.clearPositions();
                    content2 = fixer.fixUnsafe1(content2);
                    node2 = parser.parse(strFileName, new StringReader(content2), null);
                    if (node2 != null) {
                        node = node2;
                    } else {
                        fixer.clearPositions();
                        content2 = fixer.fixUnsafe2(content2);
                        node2 = parser.parse(strFileName, new StringReader(content2), (IProblemReporter)new AbstractProblemReporter(){

                            public void reportProblem(IProblem problem) {
                                if (DLTKCore.DEBUG) {
                                    System.out.println("JRubySourceParser.parse(): Fallback Parse Problem - fileName=" + strFileName + ", message=" + problem.getMessage() + ", line=" + problem.getSourceLineNumber());
                                }
                            }
                        });
                    }
                    if (node2 != null) {
                        node = node2;
                    } else {
                        fixer.clearPositions();
                    }
                }
                content = content2.toCharArray();
            }
            ModuleDeclaration module = new ModuleDeclaration(content.length);
            NodeVisitor visitor = this.getASTBuilderVisitor(module, content);
            if (node != null) {
                node.accept(visitor);
            }
            if (node != null) {
                if (TRACE_AST_JRUBY || TRACE_AST_DLTK) {
                    System.out.println("\n\nAST rebuilt\n");
                }
                if (TRACE_AST_JRUBY) {
                    System.out.println("JRuby AST:\n" + node.toString());
                }
                if (TRACE_AST_DLTK) {
                    System.out.println("DLTK AST:\n" + module.toString());
                }
            }
            fixer.correctPositionsIfNeeded(module);
            if (TRACE_AST_DLTK) {
                long eTime = System.currentTimeMillis();
                System.out.println("Parsing took " + (eTime - sTime) + " ms");
            }
            this.parserResult = parser.getParserResult();
            if (!parser.isSuccess() && module.isEmpty()) {
                module = new FakeModuleDeclaration(content.length);
                JRubySourceParser.minimumParse(content, module);
            }
            return module;
        }
        catch (Throwable t) {
            if (DLTKCore.DEBUG) {
                t.printStackTrace();
            }
            if (JRubySourceParser.isSilentState()) {
                ModuleDeclaration mdl = new ModuleDeclaration(1);
                return mdl;
            }
            throw new RuntimeException(t);
        }
    }

    public ModuleDeclaration parse(String source) {
        return this.parse(null, source.toCharArray(), null);
    }

    private static void minimumParse(char[] content, ModuleDeclaration md) {
        StringTokenizer toker = new StringTokenizer(new String(content));
        while (toker.hasMoreTokens()) {
            String superClass;
            String className;
            String token = toker.nextToken();
            if (!token.equals("class") && !token.equals("module") || !RubySyntaxUtils.isValidClass(className = toker.nextToken())) continue;
            String source = new String(content);
            int indexOf = source.indexOf(className);
            int nameEnd = indexOf + className.length();
            ConstantReference nameNode = new ConstantReference(indexOf, nameEnd, className);
            Block bodyBlock = new Block(indexOf + nameEnd, source.length() - 1);
            RubyModuleDeclaration type = token.equals("class") ? new RubyClassDeclaration(null, (ASTNode)nameNode, bodyBlock, indexOf, source.length() - 1) : new RubyModuleDeclaration((ASTNode)nameNode, bodyBlock, indexOf, source.length() - 1);
            md.addStatement((ASTNode)type);
            if (toker.nextToken().equals("<") && RubySyntaxUtils.isValidClass(superClass = toker.nextToken())) {
                indexOf = source.indexOf(className);
                type.addSuperClass((ASTNode)new ConstantReference(indexOf, indexOf + superClass.length(), superClass));
            }
            return;
        }
    }

    private class ProxyProblemReporter
    extends AbstractProblemReporter {
        private final IProblemReporter original;

        public ProxyProblemReporter(IProblemReporter original) {
            this.original = original;
        }

        public void reportProblem(IProblem problem) {
            if (this.original != null) {
                this.original.reportProblem(problem);
            }
            if (problem.isError()) {
                ((JRubySourceParser)JRubySourceParser.this).errorState[0] = true;
            }
        }
    }
}

