/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.environment;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.ui.environment.IEnvironmentPathBlockListener;
import org.eclipse.dltk.ui.environment.IEnvironmentUI;
import org.eclipse.dltk.ui.environment.Messages;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class EnvironmentPathBlock {
    private Table pathTable;
    private TableViewer pathViewer;
    private ListenerList listeners = new ListenerList();
    private Map paths = new HashMap();
    private boolean useFolders = false;

    public EnvironmentPathBlock() {
    }

    public EnvironmentPathBlock(boolean useFolders) {
        this.useFolders = useFolders;
    }

    public void createControl(Composite parent) {
        this.createControl(parent, 1);
    }

    public void createControl(Composite parent, int columns) {
        this.createControl(parent, columns, null);
    }

    public void createControl(Composite parent, IEnvironment[] environments) {
        this.createControl(parent, 1, environments);
    }

    public void createControl(Composite parent, int columns, IEnvironment[] environments) {
        PixelConverter conv = new PixelConverter((Control)parent);
        this.pathTable = new Table(parent, 67588);
        this.pathTable.setHeaderVisible(true);
        this.pathTable.setLinesVisible(true);
        GridData tableData = new GridData(4, 4, true, true);
        tableData.heightHint = conv.convertHeightInCharsToPixels(4);
        tableData.horizontalSpan = columns;
        this.pathTable.setLayoutData((Object)tableData);
        this.pathViewer = new TableViewer(this.pathTable);
        this.initColumns(this.pathViewer, conv);
        this.pathViewer.setLabelProvider((IBaseLabelProvider)this.createPathLabelProvider());
        this.pathViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof IEnvironment[]) {
                    return (Object[])inputElement;
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.pathViewer.setInput((Object)(environments != null ? environments : EnvironmentManager.getEnvironments()));
        if (this.pathTable.getItemCount() > 0) {
            this.pathTable.select(0);
        }
    }

    protected PathLabelProvider createPathLabelProvider() {
        return new PathLabelProvider(1);
    }

    protected void initColumns(TableViewer viewer, PixelConverter conv) {
        this.initEnvironmentColumn(viewer, conv);
        this.initPathColumn(viewer, conv);
    }

    protected void initEnvironmentColumn(TableViewer viewer, PixelConverter conv) {
        TableViewerColumn environmentsColumn = new TableViewerColumn(this.pathViewer, 0);
        environmentsColumn.getColumn().setText(Messages.EnvironmentPathBlock_environment);
        environmentsColumn.getColumn().setWidth(conv.convertWidthInCharsToPixels(30));
    }

    protected void initPathColumn(TableViewer viewer, PixelConverter conv) {
        TableViewerColumn pathColumn = new TableViewerColumn(this.pathViewer, 0);
        pathColumn.getColumn().setText(Messages.EnvironmentPathBlock_path);
        pathColumn.getColumn().setWidth(conv.convertWidthInCharsToPixels(40));
        pathColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.pathViewer){

            protected boolean canEdit(Object element) {
                return true;
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)EnvironmentPathBlock.this.pathTable){
                    private Button browse;
                    private Composite composite;

                    protected Control createControl(Composite compositeParent) {
                        this.composite = new Composite(compositeParent, 0);
                        this.composite.setBackground(compositeParent.getBackground());
                        GridLayout layout = new GridLayout(2, false);
                        layout.marginLeft = -4;
                        layout.marginTop = -4;
                        layout.marginBottom = -4;
                        layout.marginRight = -4;
                        this.composite.setLayout((Layout)layout);
                        super.createControl(this.composite);
                        this.text.setLayoutData((Object)new GridData(4, -1, true, false));
                        this.browse = new Button(this.composite, 8);
                        this.browse.setText("...");
                        Font font = new Font((Device)compositeParent.getDisplay(), "arial", 6, 0);
                        this.browse.setFont(font);
                        this.browse.setLayoutData((Object)new GridData(-1, 4, false, true));
                        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                EnvironmentPathBlock.this.editPath();
                                this.doFocusLost();
                            }
                        });
                        FocusAdapter listener = new FocusAdapter(){

                            public void focusLost(FocusEvent e) {
                                Control cursorControl = composite.getDisplay().getCursorControl();
                                if (cursorControl != null && cursorControl.equals(browse)) {
                                    return;
                                }
                                this.doFocusLost();
                            }
                        };
                        this.browse.addFocusListener((FocusListener)listener);
                        this.text.addFocusListener((FocusListener)listener);
                        return this.composite;
                    }

                    public void doFocusLost() {
                        super.focusLost();
                    }

                    protected void focusLost() {
                    }
                };
            }

            protected Object getValue(Object element) {
                Object value = EnvironmentPathBlock.this.paths.get(element);
                return value != null ? value : "";
            }

            protected void setValue(Object element, Object value) {
                if (value == null || "".equals(value)) {
                    EnvironmentPathBlock.this.paths.remove(element);
                } else {
                    EnvironmentPathBlock.this.paths.put(element, value);
                }
                EnvironmentPathBlock.this.pathViewer.refresh();
                EnvironmentPathBlock.this.fireValueChanged();
            }
        });
    }

    protected TableViewer getViewer() {
        return this.pathViewer;
    }

    public void addSelectionListener(ISelectionChangedListener listener) {
        this.pathViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionListener(ISelectionChangedListener listener) {
        this.pathViewer.removeSelectionChangedListener(listener);
    }

    protected void editPath() {
        ISelection selection = this.pathViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            IEnvironment environment = (IEnvironment)sel.getFirstElement();
            IEnvironmentUI ui = (IEnvironmentUI)environment.getAdapter(IEnvironmentUI.class);
            String file = null;
            file = !this.useFolders ? ui.selectFile(this.pathTable.getShell(), 0) : ui.selectFolder(this.pathTable.getShell());
            if (file != null) {
                this.paths.put(environment, file);
                this.pathViewer.refresh();
                this.fireValueChanged();
            }
        }
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.pathViewer.getSelection();
    }

    public void setPaths(Map paths) {
        this.paths = paths;
        this.pathTable.getDisplay().asyncExec(new Runnable(){

            public void run() {
                EnvironmentPathBlock.this.pathViewer.refresh();
                EnvironmentPathBlock.this.fireValueChanged();
            }
        });
    }

    public Map getPaths() {
        return this.paths;
    }

    protected void fireValueChanged() {
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final IEnvironmentPathBlockListener listener = (IEnvironmentPathBlockListener)array[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    listener.valueChanged(EnvironmentPathBlock.this.getPaths());
                }
            });
            ++i;
        }
    }

    public void addListener(IEnvironmentPathBlockListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IEnvironmentPathBlockListener listener) {
        this.listeners.add((Object)listener);
    }

    protected class PathLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final int pathColumn;

        public PathLabelProvider(int pathColumn) {
            this.pathColumn = pathColumn;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IEnvironment) {
                Object path;
                if (columnIndex == 0) {
                    return ((IEnvironment)element).getName();
                }
                if (columnIndex == this.pathColumn && (path = EnvironmentPathBlock.this.paths.get(element)) != null) {
                    return (String)path;
                }
            }
            return "";
        }
    }
}

