/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.util.QualifiedTypeNameHistory;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.completion.LazyScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.ProposalInfo;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.TypeProposalInfo;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;

public abstract class LazyScriptTypeCompletionProposal
extends LazyScriptCompletionProposal {
    protected final ISourceModule fSourceModule;
    private String fSimpleName;

    public LazyScriptTypeCompletionProposal(CompletionProposal proposal, ScriptContentAssistInvocationContext context) {
        super(proposal, context);
        this.fSourceModule = context.getSourceModule();
    }

    public final String getQualifiedTypeName() {
        return null;
    }

    protected final String getSimpleTypeName() {
        return this.fSimpleName;
    }

    protected String computeReplacementString() {
        String prefix;
        int dotIndex;
        String replacement = super.computeReplacementString();
        if (this.fProposal.getKind() == 7 && this.fInvocationContext.getCoreContext() != null && this.fInvocationContext.getCoreContext().isInDoc()) {
            return this.getSimpleTypeName();
        }
        String qualifiedTypeName = this.getQualifiedTypeName();
        if (qualifiedTypeName.indexOf(46) == -1) {
            return qualifiedTypeName;
        }
        IDocument document = this.fInvocationContext.getDocument();
        if (document != null && (dotIndex = (prefix = this.getPrefix(document, this.getReplacementOffset() + this.getReplacementLength())).lastIndexOf(46)) != -1 && qualifiedTypeName.toLowerCase().startsWith(prefix.substring(0, dotIndex + 1).toLowerCase())) {
            return qualifiedTypeName;
        }
        if (replacement.indexOf(46) == -1) {
            if (this.isInDoc()) {
                return this.getSimpleTypeName();
            }
            return replacement;
        }
        return qualifiedTypeName;
    }

    public void apply(IDocument document, char trigger, int offset) {
        boolean insertClosingParenthesis;
        boolean bl = insertClosingParenthesis = trigger == '(' && this.autocloseBrackets();
        if (insertClosingParenthesis) {
            this.updateReplacementWithParentheses();
            trigger = '\u0000';
        }
        super.apply(document, trigger, offset);
        if (insertClosingParenthesis) {
            this.setUpLinkedMode(document, ')');
        }
        try {
            this.rememberSelection();
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
    }

    private void updateReplacementWithParentheses() {
        StringBuffer replacement = new StringBuffer(this.getReplacementString());
        replacement.append("(");
        this.setCursorPosition(replacement.length());
        replacement.append(")");
        this.setReplacementString(replacement.toString());
    }

    protected final void rememberSelection() throws ModelException {
        IType lhs = this.fInvocationContext.getExpectedType();
        IType rhs = (IType)this.getModelElement();
        if (lhs != null && rhs != null) {
            DLTKUIPlugin.getDefault().getContentAssistHistory().remember(lhs, rhs);
        }
        QualifiedTypeNameHistory.remember(this.getQualifiedTypeName());
    }

    protected boolean allowAddingImports() {
        if (this.isInDoc()) {
            if (this.fProposal.getKind() == 7 && this.fInvocationContext.getCoreContext() != null && this.fInvocationContext.getCoreContext().isInDoc()) {
                return false;
            }
            if (!this.isDocProcessingEnabled()) {
                return false;
            }
        }
        IPreferenceStore preferenceStore = DLTKUIPlugin.getDefault().getPreferenceStore();
        return preferenceStore.getBoolean("content_assist_add_import");
    }

    private boolean isDocProcessingEnabled() {
        if (DLTKCore.DEBUG) {
            System.out.println("TODO: Add documentation support.");
        }
        return false;
    }

    protected boolean isValidPrefix(String prefix) {
        return this.isPrefix(prefix, this.getSimpleTypeName()) || this.isPrefix(prefix, this.getQualifiedTypeName());
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        String prefix = this.getPrefix(document, completionOffset);
        String completion = prefix.indexOf(46) != -1 ? this.getQualifiedTypeName() : this.getSimpleTypeName();
        if (this.isCamelCaseMatching()) {
            return this.getCamelCaseCompound(prefix, completion);
        }
        return completion;
    }

    protected abstract char[] getTypeTriggers();

    protected abstract char[] getDocTriggers();

    protected char[] computeTriggerCharacters() {
        return this.isInDoc() ? this.getDocTriggers() : this.getTypeTriggers();
    }

    protected ProposalInfo computeProposalInfo() {
        IScriptProject project;
        if (this.fSourceModule != null && (project = this.fSourceModule.getScriptProject()) != null) {
            return new TypeProposalInfo(project, this.fProposal);
        }
        return super.computeProposalInfo();
    }

    protected int computeRelevance() {
        float rhsHistoryRank = this.fInvocationContext.getHistoryRelevance(this.getQualifiedTypeName());
        float typeHistoryRank = QualifiedTypeNameHistory.getDefault().getNormalizedPosition(this.getQualifiedTypeName());
        int recencyBoost = Math.round((rhsHistoryRank + typeHistoryRank) * 5.0f);
        int rhsBoost = rhsHistoryRank > 0.0f ? 50 : 0;
        int baseRelevance = super.computeRelevance();
        return baseRelevance + rhsBoost + recencyBoost;
    }
}

