/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.codeassist.completion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.codeassist.complete.CompletionNodeFound;
import org.eclipse.dltk.compiler.env.lookup.Scope;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.ast.expressions.TclExecuteExpression;
import org.eclipse.dltk.tcl.core.TclKeywordsManager;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.core.ast.TclAdvancedExecuteExpression;
import org.eclipse.dltk.tcl.core.ast.TclPackageDeclaration;
import org.eclipse.dltk.tcl.core.extensions.ICompletionExtension;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclASTUtil;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclAssistParser;
import org.eclipse.dltk.tcl.internal.core.codeassist.completion.CompletionOnKeywordArgumentOrFunctionArgument;
import org.eclipse.dltk.tcl.internal.core.codeassist.completion.CompletionOnKeywordOrFunction;
import org.eclipse.dltk.tcl.internal.core.codeassist.completion.CompletionOnVariable;
import org.eclipse.dltk.tcl.internal.parser.OldTclParserUtils;

public class TclCompletionParser
extends TclAssistParser {
    private ICompletionExtension[] extensions;

    public TclCompletionParser(ICompletionExtension[] extensions) {
        this.extensions = extensions;
    }

    public void handleNotInElement(ASTNode node, int position) {
        if (node != null && node.sourceStart() <= position && position <= node.sourceEnd()) {
            if (node instanceof ModuleDeclaration) {
                ModuleDeclaration unit = (ModuleDeclaration)node;
                ArrayList<SimpleReference> exprs = new ArrayList<SimpleReference>();
                exprs.add(new SimpleReference(position, position, ""));
                TclEmptyCompleteStatement statement = new TclEmptyCompleteStatement(exprs);
                unit.addStatement((ASTNode)statement);
                this.parseBlockStatements((ASTNode)statement, (ASTNode)unit, position);
            } else if (node instanceof MethodDeclaration) {
                MethodDeclaration method = (MethodDeclaration)node;
                ArrayList<SimpleReference> exprs = new ArrayList<SimpleReference>();
                exprs.add(new SimpleReference(position, position, ""));
                TclEmptyCompleteStatement statement = new TclEmptyCompleteStatement(exprs);
                method.getStatements().add(statement);
                this.parseBlockStatements((ASTNode)statement, (ASTNode)method, position);
            } else if (node instanceof TypeDeclaration) {
                TypeDeclaration type = (TypeDeclaration)node;
                ArrayList<SimpleReference> exprs = new ArrayList<SimpleReference>();
                exprs.add(new SimpleReference(position, position, ""));
                TclEmptyCompleteStatement statement = new TclEmptyCompleteStatement(exprs);
                type.getStatements().add(statement);
                this.parseBlockStatements((ASTNode)statement, (ASTNode)type, position);
            } else if (node instanceof TclExecuteExpression) {
                ArrayList<SimpleReference> exprs = new ArrayList<SimpleReference>();
                exprs.add(new SimpleReference(position, position, ""));
                TclEmptyCompleteStatement statement = new TclEmptyCompleteStatement(exprs);
                this.parseBlockStatements((ASTNode)statement, node, position);
            }
        }
    }

    public void parseBlockStatements(ASTNode node, ASTNode inNode, int position) {
        if (node instanceof TclStatement) {
            ASTNode n;
            int i;
            List exprs;
            int maxLen;
            SimpleReference nde;
            TclStatement statement = (TclStatement)node;
            List expressions = statement.getExpressions();
            int len = expressions.size();
            boolean first = false;
            String completionToken = null;
            ASTNode completionNode = null;
            int i2 = 0;
            while (i2 < len) {
                ASTNode n2 = (ASTNode)expressions.get(i2);
                if (n2.sourceStart() <= position && n2.sourceEnd() >= position || node instanceof TclEmptyCompleteStatement) {
                    if (i2 == 0) {
                        first = true;
                    }
                    completionNode = n2;
                }
                ++i2;
            }
            if (completionNode == null) {
                if (len > 0) {
                    String[] keywords = this.checkKeywords(completionToken, 1);
                    nde = new CompletionOnKeywordArgumentOrFunctionArgument("", (TclStatement)node, keywords, position);
                    this.assistNodeParent = inNode;
                    throw new CompletionNodeFound((ASTNode)nde, null);
                }
                completionToken = "";
            } else if (completionNode instanceof SimpleReference) {
                maxLen = position - completionNode.sourceStart();
                completionToken = ((SimpleReference)completionNode).getName();
                if (completionToken.length() > maxLen && maxLen > 0) {
                    completionToken = completionToken.substring(0, maxLen);
                }
            }
            if (completionNode instanceof StringLiteral) {
                maxLen = position - completionNode.sourceStart();
                int pos = maxLen;
                SimpleReference tok = OldTclParserUtils.extractVariableFromString((StringLiteral)completionNode, pos);
                if (tok != null) {
                    this.assistNodeParent = inNode;
                    CompletionOnVariable nde2 = new CompletionOnVariable(tok.getName(), (ASTNode)tok, node, inNode, false);
                    throw new CompletionNodeFound((ASTNode)nde2, null);
                }
                this.assistNodeParent = inNode;
                SimpleReference ref = new SimpleReference(position, position, "");
                CompletionOnVariable nde3 = new CompletionOnVariable("", (ASTNode)ref, node, inNode, true);
                throw new CompletionNodeFound((ASTNode)nde3, null);
            }
            if (completionNode instanceof TclExecuteExpression) {
                TclExecuteExpression expr = (TclExecuteExpression)completionNode;
                exprs = expr.parseExpression();
                i = 0;
                while (i < exprs.size()) {
                    n = (ASTNode)exprs.get(i);
                    if (n.sourceStart() <= position && n.sourceEnd() >= position) {
                        this.parseBlockStatements(n, (ASTNode)expr, position);
                    }
                    ++i;
                }
                this.handleNotInElement((ASTNode)expr, position);
            }
            if (completionNode instanceof TclAdvancedExecuteExpression) {
                TclAdvancedExecuteExpression expr = (TclAdvancedExecuteExpression)completionNode;
                exprs = expr.getStatements();
                i = 0;
                while (i < exprs.size()) {
                    n = (ASTNode)exprs.get(i);
                    if (n.sourceStart() <= position && n.sourceEnd() >= position) {
                        this.parseBlockStatements(n, (ASTNode)expr, position);
                    }
                    ++i;
                }
            }
            if (completionNode instanceof TclBlockExpression) {
                TclBlockExpression block = (TclBlockExpression)completionNode;
                List s = block.parseBlockSimple();
                if (s != null) {
                    int slen = s.size();
                    int u = 0;
                    while (u < slen) {
                        ASTNode n3 = (ASTNode)s.get(u);
                        n3.setStart(n3.sourceStart() - block.sourceStart());
                        n3.setEnd(n3.sourceEnd() - block.sourceStart());
                        TclASTUtil.extendStatement(n3, block.getBlock());
                        n3.setStart(n3.sourceStart() + block.sourceStart());
                        n3.setEnd(n3.sourceEnd() + block.sourceStart());
                        if (n3.sourceStart() <= position && n3.sourceEnd() >= position) {
                            this.parseBlockStatements(n3, inNode, position);
                        }
                        ++u;
                    }
                }
                this.handleNotInElement(inNode, position);
            }
            if (completionToken != null && completionToken.startsWith("$")) {
                this.assistNodeParent = inNode;
                CompletionOnVariable nde4 = new CompletionOnVariable(completionToken, completionNode, node, inNode, false);
                throw new CompletionNodeFound((ASTNode)nde4, null);
            }
            if (inNode instanceof ModuleDeclaration && completionNode != null && first) {
                String[] keywords = this.checkKeywords(completionToken, 1);
                nde = new CompletionOnKeywordOrFunction(completionToken, completionNode, node, keywords);
                this.assistNodeParent = inNode;
                throw new CompletionNodeFound((ASTNode)nde, (Scope)((ModuleDeclaration)inNode).scope);
            }
            if (inNode instanceof MethodDeclaration && completionNode != null && first) {
                String[] keywords = this.checkKeywords(completionToken, 3);
                nde = new CompletionOnKeywordOrFunction(completionToken, completionNode, TclParseUtil.getScopeParent(this.getModule(), node), keywords);
                this.assistNodeParent = inNode;
                throw new CompletionNodeFound((ASTNode)nde, (Scope)((MethodDeclaration)inNode).scope);
            }
            if (inNode instanceof TypeDeclaration && completionNode != null && first) {
                String[] keywords = this.checkKeywords(completionToken, 2);
                nde = new CompletionOnKeywordOrFunction(completionToken, completionNode, node, keywords);
                this.assistNodeParent = inNode;
                throw new CompletionNodeFound((ASTNode)nde, null);
            }
            if (inNode instanceof TclExecuteExpression && completionNode != null && first) {
                String[] keywords = this.checkKeywords(completionToken, 4);
                nde = new CompletionOnKeywordOrFunction(completionToken, completionNode, node, keywords);
                this.assistNodeParent = inNode;
                throw new CompletionNodeFound((ASTNode)nde, null);
            }
            if (completionNode != null) {
                String[] keywords = this.checkKeywords(completionToken, 1);
                nde = new CompletionOnKeywordArgumentOrFunctionArgument(completionToken, completionNode, (TclStatement)node, keywords);
                this.assistNodeParent = inNode;
                throw new CompletionNodeFound((ASTNode)nde, null);
            }
            String[] keywords = this.checkKeywords(completionToken, 1);
            if (completionToken == null) {
                completionToken = "";
            }
            nde = new CompletionOnKeywordArgumentOrFunctionArgument(completionToken, (TclStatement)node, keywords, position);
            this.assistNodeParent = inNode;
            throw new CompletionNodeFound((ASTNode)nde, null);
        }
        if (node instanceof MethodDeclaration) {
            MethodDeclaration method = (MethodDeclaration)node;
            List statements = method.getStatements();
            boolean inStatement = false;
            if (statements != null) {
                int length = statements.size();
                int i = 0;
                while (i < length) {
                    ASTNode nde = (ASTNode)statements.get(i);
                    if (nde.sourceStart() <= position && nde.sourceEnd() >= position) {
                        inStatement = true;
                        this.parseBlockStatements(nde, (ASTNode)method, position);
                    }
                    ++i;
                }
            }
            if (!inStatement) {
                this.handleNotInElement((ASTNode)method, position);
            }
        } else {
            this.visitElements(node, position);
        }
    }

    protected CompletionVisitor createCompletionVisitor(int position) {
        return new CompletionVisitor(position, this.getModule());
    }

    private void visitElements(ASTNode node, int position) {
        if (!(node instanceof TclStatement)) {
            CompletionVisitor visitor = this.createCompletionVisitor(position);
            try {
                node.traverse((ASTVisitor)visitor);
            }
            catch (CompletionNodeFound e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean checkVariableWithoutDollarCompletion(TclStatement statement, int position) {
        SimpleReference ref;
        String name;
        Expression e = statement.getAt(0);
        return e instanceof SimpleReference && (name = (ref = (SimpleReference)e).getName()).equals("set");
    }

    public String[] checkKeywords(String completionToken, int type) {
        String[] keywords = TclKeywordsManager.getKeywords(type);
        if (type == 1 || type == 3 || type == 2 || type == 4) {
            String[] kw = new String[keywords.length];
            int i = 0;
            while (i < keywords.length) {
                kw[i] = keywords[i];
                ++i;
            }
            return kw;
        }
        return null;
    }

    public void setAssistNodeParent(ASTNode prevParent) {
        this.assistNodeParent = prevParent;
    }

    public class CompletionVisitor
    extends ASTVisitor {
        protected int position;
        protected ModuleDeclaration module;

        public CompletionVisitor(int position, ModuleDeclaration module) {
            this.position = position;
            this.module = module;
        }

        public boolean visit(Statement s) throws Exception {
            if (s.sourceStart() <= this.position && s.sourceEnd() >= this.position) {
                TclPackageDeclaration decl;
                int i = 0;
                while (i < TclCompletionParser.this.extensions.length) {
                    TclCompletionParser.this.extensions[i].visit(s, TclCompletionParser.this, this.position);
                    ++i;
                }
                if (s instanceof TclStatement) {
                    ASTNode inNode = TclParseUtil.getScopeParent(this.module, (ASTNode)s);
                    TclCompletionParser.this.parseBlockStatements((ASTNode)s, inNode, this.position);
                }
                if (s instanceof TclPackageDeclaration && (decl = (TclPackageDeclaration)s).getNameStart() <= this.position && this.position <= decl.getNameEnd()) {
                    ASTNode inNode = TclParseUtil.getScopeParent(this.module, (ASTNode)s);
                    TclCompletionParser.this.assistNodeParent = inNode;
                    throw new CompletionNodeFound((ASTNode)decl, null);
                }
            }
            return super.visit(s);
        }

        public boolean visit(Expression s) throws Exception {
            if (s.sourceStart() <= this.position && s.sourceEnd() >= this.position) {
                int i = 0;
                while (i < TclCompletionParser.this.extensions.length) {
                    TclCompletionParser.this.extensions[i].visit(s, TclCompletionParser.this, this.position);
                    ++i;
                }
            }
            return super.visit(s);
        }

        public boolean endvisit(Expression s) throws Exception {
            if (s instanceof Block && s.sourceStart() <= this.position && s.sourceEnd() >= this.position) {
                String[] keywords = TclCompletionParser.this.checkKeywords("", 1);
                ASTNode inNode = TclParseUtil.getScopeParent(this.module, (ASTNode)s);
                CompletionOnKeywordOrFunction nde = new CompletionOnKeywordOrFunction("", inNode, (ASTNode)s, keywords);
                TclCompletionParser.this.assistNodeParent = inNode;
                throw new CompletionNodeFound((ASTNode)nde, null);
            }
            return super.endvisit(s);
        }
    }

    private static class TclEmptyCompleteStatement
    extends TclStatement {
        public TclEmptyCompleteStatement(List expressions) {
            super(expressions);
        }
    }
}

