/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ast.references;

import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.ast.references.Reference;
import org.eclipse.dltk.utils.CorePrinter;

public class SimpleReference
extends Reference {
    protected String fName;

    public SimpleReference(int start, int end, String name) {
        super(start, end);
        this.fName = name;
    }

    public SimpleReference(DLTKToken token) {
        this.fName = token.getText();
        this.setStart(token.getColumn());
        if (this.fName != null) {
            this.setEnd(this.sourceStart() + this.fName.length());
        }
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getStringRepresentation() {
        return this.fName;
    }

    public void printNode(CorePrinter output) {
        output.formatPrintLn(String.valueOf(this.fName) + "(" + this.getSourceRange().toString() + ")");
    }

    public String toString() {
        return this.fName;
    }
}

