/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IProjectIndexer;
import org.eclipse.dltk.core.search.indexing.core.ExternalProjectFragmentRequest;

class BuiltinProjectFragmentRequest
extends ExternalProjectFragmentRequest {
    private final long lastModified;

    public BuiltinProjectFragmentRequest(IProjectIndexer indexer, IProjectFragment fragment, IDLTKLanguageToolkit toolkit, long lastModified) {
        super(indexer, fragment, toolkit);
        this.lastModified = lastModified;
    }

    protected List checkChanges(Index index, Collection modules, IPath containerPath, IEnvironment environment) throws ModelException, IOException {
        long indexLastModified = index.getIndexFile().lastModified();
        if (this.lastModified > indexLastModified) {
            ArrayList<String> changes = new ArrayList<String>();
            String[] documentNames = this.queryDocumentNames(index);
            if (documentNames != null) {
                int i = 0;
                while (i < documentNames.length) {
                    changes.add(documentNames[i]);
                    ++i;
                }
            }
            changes.addAll(modules);
            return changes;
        }
        return super.checkChanges(index, modules, containerPath, environment);
    }

    protected IEnvironment getEnvironment() {
        return null;
    }

    public boolean equals(Object obj) {
        return obj instanceof BuiltinProjectFragmentRequest && super.equals(obj);
    }
}

