/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.serialization;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemCollector;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.caching.AbstractDataSaver;
import org.eclipse.dltk.tcl.ast.ComplexString;
import org.eclipse.dltk.tcl.ast.Script;
import org.eclipse.dltk.tcl.ast.StringArgument;
import org.eclipse.dltk.tcl.ast.Substitution;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclArgumentList;
import org.eclipse.dltk.tcl.ast.TclCodeModel;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.ast.TclModule;
import org.eclipse.dltk.tcl.ast.VariableReference;
import org.eclipse.dltk.tcl.definitions.Command;
import org.eclipse.dltk.tcl.internal.core.serialization.ITclASTConstants;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class TclASTSaver
extends AbstractDataSaver
implements ITclASTConstants {
    private TclModule module;
    private ProblemCollector collector;

    public TclASTSaver(TclModule module, OutputStream stream) throws IOException {
        super(stream);
        this.module = module;
    }

    public void writeInt(int value) throws IOException {
        if (this.module.getSize() < 127) {
            this.out.writeByte(value);
        } else if (this.module.getSize() < Short.MAX_VALUE) {
            this.out.writeShort(value);
        } else {
            this.out.writeInt(value);
        }
    }

    public void store(ProblemCollector collector) throws IOException {
        this.collector = collector;
        this.storeContent();
        this.storeStringIndex();
    }

    protected void storeContent() throws IOException {
        this.out.writeByte(0);
        this.out.writeInt(this.module.getSize());
        EList<TclCommand> statements = this.module.getStatements();
        this.out.writeInt(statements.size());
        for (TclCommand tclCommand : statements) {
            this.out(tclCommand);
        }
        TclCodeModel codeModel = this.module.getCodeModel();
        if (codeModel != null) {
            this.out.writeBoolean(true);
            EList<String> delimeters = codeModel.getDelimeters();
            this.out.writeInt(delimeters.size());
            for (String del : delimeters) {
                this.writeString(del);
            }
            EList<Integer> lineOffsets = codeModel.getLineOffsets();
            this.out.writeInt(lineOffsets.size());
            for (Integer integer : lineOffsets) {
                this.writeInt(integer);
            }
        } else {
            this.out.writeBoolean(false);
        }
        if (this.collector != null) {
            int size = this.collector.getErrors().size();
            this.out.writeInt(size);
            this.collector.copyTo(new IProblemReporter(){

                public Object getAdapter(Class adapter) {
                    return null;
                }

                public void reportProblem(IProblem problem) {
                    block2: {
                        try {
                            TclASTSaver.this.saveProblem(problem);
                        }
                        catch (IOException e) {
                            if (!DLTKCore.DEBUG) break block2;
                            e.printStackTrace();
                        }
                    }
                }
            });
        } else {
            this.out.writeInt(0);
        }
    }

    private void saveProblem(IProblem problem) throws IOException {
        this.out.writeByte(8);
        this.out.writeInt(problem.getID());
        this.writeString(problem.getMessage());
        this.writeInt(problem.getSourceStart());
        this.writeInt(problem.getSourceEnd() - problem.getSourceStart());
        if (problem.getArguments() != null) {
            this.out.writeInt(problem.getArguments().length);
            String[] stringArray = problem.getArguments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                this.writeString(arg);
                ++n2;
            }
        } else {
            this.out.writeInt(0);
        }
        this.out.writeBoolean(problem.isError());
        this.out.writeBoolean(problem.isWarning());
        this.writeInt(problem.getSourceLineNumber());
    }

    public void out(TclArgument arg) throws IOException {
        if (arg instanceof StringArgument) {
            StringArgument argument = (StringArgument)arg;
            String value = argument.getValue();
            this.out.writeByte(2);
            this.writeInt(arg.getStart());
            this.writeInt(arg.getEnd() - arg.getStart());
            this.writeString(value);
        } else if (arg instanceof ComplexString) {
            ComplexString carg = (ComplexString)arg;
            this.out.writeByte(3);
            this.out.writeInt(carg.getKind());
            this.writeInt(arg.getStart());
            this.writeInt(arg.getEnd() - arg.getStart());
            EList<TclArgument> eList = carg.getArguments();
            this.out.writeInt(eList.size());
            for (TclArgument tclArgument : eList) {
                this.out(tclArgument);
            }
        } else if (arg instanceof Script) {
            Script st = (Script)arg;
            EList<TclCommand> eList = st.getCommands();
            this.out.writeByte(4);
            this.writeInt(arg.getStart());
            this.writeInt(arg.getEnd() - arg.getStart());
            this.writeInt(st.getContentStart());
            this.writeInt(st.getContentEnd() - st.getContentStart());
            this.out.writeInt(eList.size());
            for (TclCommand tclArgument : eList) {
                this.out(tclArgument);
            }
        } else if (arg instanceof VariableReference) {
            VariableReference var = (VariableReference)arg;
            this.out.writeByte(6);
            this.writeInt(arg.getStart());
            this.writeInt(arg.getEnd() - arg.getStart());
            this.writeString(var.getName());
            TclArgument index = var.getIndex();
            if (index == null) {
                this.out.writeBoolean(false);
            } else {
                this.out.writeBoolean(true);
                this.out(index);
            }
        } else if (arg instanceof Substitution) {
            Substitution st = (Substitution)arg;
            EList<TclCommand> eList = st.getCommands();
            this.out.writeByte(5);
            this.writeInt(arg.getStart());
            this.writeInt(arg.getEnd() - arg.getStart());
            this.out.writeInt(eList.size());
            for (TclCommand tclArgument : eList) {
                this.out(tclArgument);
            }
        } else if (arg instanceof TclArgumentList) {
            TclArgumentList st = (TclArgumentList)arg;
            this.out.writeByte(7);
            this.out.writeInt(st.getKind());
            this.writeInt(arg.getStart());
            this.writeInt(arg.getEnd() - arg.getStart());
            EList<TclArgument> arguments = st.getArguments();
            this.out.writeInt(arguments.size());
            for (TclArgument tclArgument : arguments) {
                this.out(tclArgument);
            }
            this.storeERef(st.getDefinitionArgument());
        }
    }

    public void out(TclCommand command) throws IOException {
        this.out.writeByte(1);
        this.writeInt(command.getStart());
        this.writeInt(command.getEnd());
        this.writeString(command.getQualifiedName());
        Command def = command.getDefinition();
        this.storeERef(def);
        this.out(command.getName());
        this.out.writeInt(command.getArguments().size());
        EList<TclArgument> eList = command.getArguments();
        for (TclArgument tclArgument : eList) {
            this.out(tclArgument);
        }
    }

    private void storeERef(EObject def) throws IOException {
        if (def == null) {
            this.out.writeBoolean(false);
        } else {
            this.out.writeBoolean(true);
            URI uri = EcoreUtil.getURI((EObject)def);
            String defURI = uri.fragment();
            this.writeString(defURI);
        }
    }
}

