/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import java.io.IOException;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.typeinference.CombinedOrReference;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.NewReference;
import org.eclipse.dltk.internal.javascript.typeinference.StandardSelfCompletingReference;
import org.eclipse.dltk.javascript.core.JavaScriptPlugin;
import org.eclipse.dltk.utils.TextUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLLiteralInferencer
extends DefaultHandler {
    private final SAXParser parser;
    private ReferenceResolverContext context;
    private Stack<IReference> stack = new Stack();

    public XMLLiteralInferencer() {
        try {
            this.parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new LinkageError();
        }
        catch (SAXException sAXException) {
            throw new LinkageError();
        }
    }

    public void modifyReference(IReference reference, String string, ReferenceResolverContext cs) {
        this.context = cs;
        this.stack.clear();
        this.stack.push(reference);
        try {
            this.parser.parse(new InputSource(new StringReader(string)), (DefaultHandler)this);
        }
        catch (SAXException e) {
            JavaScriptPlugin.error(e);
        }
        catch (IOException e) {
            JavaScriptPlugin.error(e);
        }
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.stack.size() > 1) {
            if (name.indexOf(58) != -1) {
                name = TextUtils.replace((String)name, (char)':', (String)"::");
            }
            CombinedOrReference corf = new CombinedOrReference(new NewReference(name, "XML", this.context), new StandardSelfCompletingReference(name, true));
            this.stack.peek().setChild(name, corf);
            this.stack.push(corf);
        } else {
            this.stack.push(this.stack.peek());
        }
        int a = 0;
        int length = attributes.getLength();
        while (a < length) {
            String val = "@" + attributes.getQName(a);
            if (val.indexOf(58) != -1) {
                val = TextUtils.replace((String)val, (char)':', (String)"::");
            }
            CombinedOrReference attrCorf = new CombinedOrReference(new NewReference(val, "XMLATTR", null), new StandardSelfCompletingReference(val, true));
            this.stack.peek().setChild(val, attrCorf);
            ++a;
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        this.stack.pop();
    }
}

