/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TypeKind implements Enumerator
{
    UNKNOWN(-1, "UNKNOWN", "UNKNOWN"),
    PREDEFINED(0, "PREDEFINED", "PREDEFINED"),
    JAVASCRIPT(1, "JAVASCRIPT", "JAVASCRIPT"),
    JAVA(2, "JAVA", "JAVA");

    public static final int UNKNOWN_VALUE = -1;
    public static final int PREDEFINED_VALUE = 0;
    public static final int JAVASCRIPT_VALUE = 1;
    public static final int JAVA_VALUE = 2;
    private static final TypeKind[] VALUES_ARRAY;
    public static final List<TypeKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TypeKind[]{UNKNOWN, PREDEFINED, JAVASCRIPT, JAVA};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TypeKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TypeKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TypeKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TypeKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TypeKind get(int value) {
        switch (value) {
            case -1: {
                return UNKNOWN;
            }
            case 0: {
                return PREDEFINED;
            }
            case 1: {
                return JAVASCRIPT;
            }
            case 2: {
                return JAVA;
            }
        }
        return null;
    }

    private TypeKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

