/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.Keywords;

public class UnaryOperation
extends Expression {
    private Expression expression;
    private int operation = -1;
    private int operationPos = -1;

    public UnaryOperation(ASTNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.expression != null) {
                this.expression.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public int getOperation() {
        return this.operation;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public int getOperationPosition() {
        return this.operationPos;
    }

    public void setOperationPosition(int operationPos) {
        this.operationPos = operationPos;
    }

    public String getOperationText() {
        return Keywords.fromToken(this.operation);
    }

    public boolean isPostfix() {
        return this.operation == 147 || this.operation == 146;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.operationPos > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.operation > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        if (!this.isPostfix()) {
            buffer.append(this.getOperationText());
        }
        buffer.append(this.expression.toSourceString(indentationString));
        if (this.isPostfix()) {
            buffer.append(this.getOperationText());
        }
        return buffer.toString();
    }
}

