/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.model;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.ILocalVariable;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.dltk.internal.core.SourceRefElement;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.internal.core.util.Util;

public class LocalVariable
extends SourceRefElement
implements ILocalVariable {
    String name;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int nameStart;
    public int nameEnd;
    String type;

    public LocalVariable(IModelElement parent, String name, int declarationSourceStart, int declarationSourceEnd, int nameStart, int nameEnd, String type) {
        super((ModelElement)parent);
        this.name = name;
        this.declarationSourceStart = declarationSourceStart;
        this.declarationSourceEnd = declarationSourceEnd;
        this.nameStart = nameStart;
        this.nameEnd = nameEnd;
        this.type = type;
    }

    protected void closing(Object info) {
    }

    protected Object createElementInfo() {
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocalVariable)) {
            return false;
        }
        LocalVariable other = (LocalVariable)o;
        return this.declarationSourceStart == other.declarationSourceStart && this.declarationSourceEnd == other.declarationSourceEnd && this.nameStart == other.nameStart && this.nameEnd == other.nameEnd && super.equals(o);
    }

    public boolean exists() {
        return this.parent.exists();
    }

    protected void generateInfos(Object info, HashMap newElements, IProgressMonitor pm) {
    }

    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, owner);
            }
        }
        return this;
    }

    public void getHandleMemento(StringBuffer buff) {
        ((ModelElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        buff.append(this.name);
        buff.append('!');
        buff.append(this.declarationSourceStart);
        buff.append('!');
        buff.append(this.declarationSourceEnd);
        buff.append('!');
        buff.append(this.nameStart);
        buff.append('!');
        buff.append(this.nameEnd);
        buff.append('!');
        this.escapeMementoName(buff, this.type);
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
    }

    protected char getHandleMementoDelimiter() {
        return '@';
    }

    public IResource getCorrespondingResource() {
        return null;
    }

    public String getElementName() {
        return this.name;
    }

    public int getElementType() {
        return 13;
    }

    public ISourceRange getNameRange() {
        return new SourceRange(this.nameStart, this.nameEnd - this.nameStart + 1);
    }

    public IPath getPath() {
        return this.parent.getPath();
    }

    public String getSource() throws ModelException {
        IOpenable openable = this.parent.getOpenableParent();
        IBuffer buffer = openable.getBuffer();
        if (buffer == null) {
            return null;
        }
        ISourceRange range = this.getSourceRange();
        int offset = range.getOffset();
        int length = range.getLength();
        if (offset == -1 || length == 0) {
            return null;
        }
        try {
            return buffer.getText(offset, length);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public ISourceRange getSourceRange() {
        return new SourceRange(this.declarationSourceStart, this.declarationSourceEnd - this.declarationSourceStart + 1);
    }

    public String getType() {
        return this.type;
    }

    public IResource getUnderlyingResource() throws ModelException {
        return this.parent.getUnderlyingResource();
    }

    public int hashCode() {
        return Util.combineHashCodes(this.parent.hashCode(), this.nameStart);
    }

    public boolean isStructureKnown() throws ModelException {
        return true;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info != NO_INFO && this.getType() != null) {
            buffer.append(this.getType());
            buffer.append(" ");
        }
        this.toStringName(buffer);
    }
}

