/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.matching2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.core.search.matching2.HashtableOfLong;
import org.eclipse.dltk.core.search.matching2.IMatchingNodeSet;
import org.eclipse.dltk.core.search.matching2.MatchLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MatchingNodeSet<E>
implements IMatchingNodeSet<E>,
Comparator<E> {
    private Map<E, MatchLevel> matchingNodes = new HashMap<E, MatchLevel>();
    private HashtableOfLong<E> matchingNodesKeys = new HashtableOfLong();
    private Set<E> possibleMatchingNodes = new HashSet();
    private HashtableOfLong<E> possibleMatchingNodesKeys = new HashtableOfLong();

    @Override
    public MatchLevel addMatch(E node, MatchLevel matchLevel) {
        switch (matchLevel) {
            case POSSIBLE_MATCH: {
                this.addPossibleMatch(node);
                break;
            }
            case INACCURATE_MATCH: {
                this.addTrustedMatch(node, MatchLevel.INACCURATE_MATCH);
                break;
            }
            case ACCURATE_MATCH: {
                this.addTrustedMatch(node, MatchLevel.ACCURATE_MATCH);
            }
        }
        return matchLevel;
    }

    public void addPossibleMatch(E node) {
        long key = this.computeNodeKey(node);
        E existing = this.possibleMatchingNodesKeys.get(key);
        if (existing != null && existing.getClass().equals(node.getClass())) {
            this.possibleMatchingNodes.remove(existing);
        }
        this.possibleMatchingNodes.add(node);
        this.possibleMatchingNodesKeys.put(key, node);
    }

    private void addTrustedMatch(E node, MatchLevel level) {
        long key = this.computeNodeKey(node);
        E existing = this.matchingNodesKeys.get(key);
        if (existing != null && existing.getClass().equals(node.getClass())) {
            this.matchingNodes.remove(existing);
        }
        this.matchingNodes.put(node, level);
        this.matchingNodesKeys.put(key, node);
    }

    protected boolean hasPossibleNodes(int start, int end) {
        for (E node : this.possibleMatchingNodes) {
            if (!this.checkRange(node, start, end)) continue;
            return true;
        }
        for (E node : this.matchingNodes.keySet()) {
            if (!this.checkRange(node, start, end)) continue;
            return true;
        }
        return false;
    }

    public List<E> matchingNodes(int start, int end) {
        ArrayList<E> nodes = null;
        for (E node : this.matchingNodes.keySet()) {
            if (!this.checkRange(node, start, end)) continue;
            if (nodes == null) {
                nodes = new ArrayList<E>();
            }
            nodes.add(node);
        }
        if (nodes == null) {
            return Collections.emptyList();
        }
        Collections.sort(nodes, this);
        return nodes;
    }

    public List<E> matchingNodes() {
        ArrayList nodes = new ArrayList(this.matchingNodes.keySet());
        Collections.sort(nodes, this);
        return nodes;
    }

    public boolean removePossibleMatch(E node) {
        long key = this.computeNodeKey(node);
        E existing = this.possibleMatchingNodesKeys.get(key);
        if (existing == null) {
            return false;
        }
        this.possibleMatchingNodesKeys.put(key, null);
        return this.possibleMatchingNodes.remove(node);
    }

    protected abstract long computeNodeKey(E var1);

    protected abstract boolean checkRange(E var1, int var2, int var3);

    public MatchLevel removeTrustedMatch(E node) {
        long key = this.computeNodeKey(node);
        E existing = this.matchingNodesKeys.get(key);
        if (existing == null) {
            return null;
        }
        this.matchingNodesKeys.put(key, null);
        return this.matchingNodes.remove(node);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Exact matches:");
        ArrayList<E> nodes = new ArrayList<E>(this.matchingNodes.keySet());
        Collections.sort(nodes, this);
        for (Object node : nodes) {
            result.append("\n\t");
            result.append((Object)this.matchingNodes.get(node));
            result.append(this.describeNode(node));
        }
        result.append("\nPossible matches:");
        nodes.clear();
        nodes.addAll(this.possibleMatchingNodes);
        Collections.sort(nodes, this);
        for (Object node : nodes) {
            result.append("\nPOSSIBLE_MATCH: ");
            result.append(this.describeNode(node));
        }
        return result.toString();
    }

    protected String describeNode(E node) {
        return node.toString();
    }

    public void clear() {
        this.matchingNodes.clear();
        this.matchingNodesKeys.clear();
        this.clearPossibleMatchingNodes();
    }

    public void clearPossibleMatchingNodes() {
        this.possibleMatchingNodes.clear();
        this.possibleMatchingNodesKeys.clear();
    }

    public Collection<E> getPossibleMatchingNodes() {
        return this.possibleMatchingNodes;
    }

    public int countMatchingNodes() {
        return this.matchingNodes.size();
    }

    public int countPossibleMatchingNodes() {
        return this.possibleMatchingNodes.size();
    }

    public boolean isEmpty() {
        return this.matchingNodes.isEmpty() && this.possibleMatchingNodes.isEmpty();
    }
}

