/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.sql.h2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.index.sql.Element;
import org.eclipse.dltk.core.index.sql.IElementDao;
import org.eclipse.dltk.core.index.sql.IElementHandler;
import org.eclipse.dltk.core.index.sql.h2.H2Index;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.index.sql.h2.H2Cache;
import org.eclipse.dltk.internal.core.index.sql.h2.Schema;
import org.eclipse.osgi.util.NLS;

public class H2ElementDao
implements IElementDao {
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile(",");
    private static final String Q_INSERT_REF = Schema.readSqlFile("resources/insert_ref.sql");
    private static final String Q_INSERT_DECL = Schema.readSqlFile("resources/insert_decl.sql");
    private static final Map<String, String> R_INSERT_QUERY_CACHE = new HashMap<String, String>();
    private static final Map<String, String> D_INSERT_QUERY_CACHE = new HashMap<String, String>();
    private final ModelManager modelManager = ModelManager.getModelManager();
    private final Map<String, PreparedStatement> batchStatements = new HashMap<String, PreparedStatement>();

    private String getTableName(Connection connection, int elementType, String natureId, boolean isReference) throws SQLException {
        Schema schema = new Schema();
        String tableName = schema.getTableName(elementType, natureId, isReference);
        schema.createTable(connection, tableName, isReference);
        return tableName;
    }

    private void insertBatch(Connection connection, PreparedStatement statement, int type, int flags, int offset, int length, int nameOffset, int nameLength, String name, String metadata, String qualifier, String parent, int fileId, String natureId, boolean isReference) throws SQLException {
        int param = 0;
        if (!isReference) {
            statement.setInt(++param, flags);
        }
        statement.setInt(++param, offset);
        statement.setInt(++param, length);
        if (!isReference) {
            statement.setInt(++param, nameOffset);
            statement.setInt(++param, nameLength);
        }
        statement.setString(++param, name);
        String camelCaseName = null;
        if (!isReference) {
            StringBuilder camelCaseNameBuf = new StringBuilder();
            int i = 0;
            while (i < name.length()) {
                char ch = name.charAt(i);
                if (Character.isUpperCase(ch)) {
                    camelCaseNameBuf.append(ch);
                } else if (i == 0) break;
                ++i;
            }
            camelCaseName = camelCaseNameBuf.length() > 0 ? camelCaseNameBuf.toString() : null;
            statement.setString(++param, camelCaseName);
        }
        statement.setString(++param, metadata);
        statement.setString(++param, qualifier);
        if (!isReference) {
            statement.setString(++param, parent);
        }
        statement.setInt(++param, fileId);
        statement.addBatch();
        if (!isReference) {
            H2Cache.addElement(new Element(type, flags, offset, length, nameOffset, nameLength, name, camelCaseName, metadata, qualifier, parent, fileId, isReference));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Connection connection, int type, int flags, int offset, int length, int nameOffset, int nameLength, String name, String metadata, String qualifier, String parent, int fileId, String natureId, boolean isReference) throws SQLException {
        String query;
        String tableName = this.getTableName(connection, type, natureId, isReference);
        if (isReference) {
            query = R_INSERT_QUERY_CACHE.get(tableName);
            if (query == null) {
                query = NLS.bind((String)Q_INSERT_REF, (Object)tableName);
                R_INSERT_QUERY_CACHE.put(tableName, query);
            }
        } else {
            query = D_INSERT_QUERY_CACHE.get(tableName);
            if (query == null) {
                query = NLS.bind((String)Q_INSERT_DECL, (Object)tableName);
                D_INSERT_QUERY_CACHE.put(tableName, query);
            }
        }
        Map<String, PreparedStatement> map = this.batchStatements;
        synchronized (map) {
            PreparedStatement statement = this.batchStatements.get(query);
            if (statement == null) {
                statement = connection.prepareStatement(query);
                this.batchStatements.put(query, statement);
            }
            this.insertBatch(connection, statement, type, flags, offset, length, nameOffset, nameLength, name, metadata, qualifier, parent, fileId, natureId, isReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitInsertions() throws SQLException {
        Map<String, PreparedStatement> map = this.batchStatements;
        synchronized (map) {
            try {
                for (PreparedStatement statement : this.batchStatements.values()) {
                    try {
                        statement.executeBatch();
                    }
                    finally {
                        statement.close();
                    }
                }
            }
            finally {
                this.batchStatements.clear();
            }
        }
    }

    private String escapeBackslash(String pattern) {
        return pattern.replaceAll("\\\\", "\\\\\\\\");
    }

    public void search(Connection connection, String pattern, ISearchEngine.MatchRule matchRule, int elementType, int trueFlags, int falseFlags, String qualifier, String parent, int[] filesId, int[] containersId, String natureId, int limit, boolean isReference, IElementHandler handler, IProgressMonitor monitor) throws SQLException {
        long timeStamp = System.currentTimeMillis();
        int count = 0;
        if (!isReference && H2Cache.isLoaded()) {
            Collection<Element> elements = H2Cache.searchElements(pattern, matchRule, elementType, trueFlags, falseFlags, qualifier, parent, filesId, containersId, natureId, limit);
            if (elements != null && elements.size() > 0) {
                for (Element element : elements) {
                    handler.handle(element);
                }
            }
            return;
        }
        String tableName = this.getTableName(connection, elementType, natureId, isReference);
        Statement statement = connection.createStatement();
        try {
            StringBuilder query = new StringBuilder("SELECT * FROM ").append(tableName);
            query.append(" WHERE 1=1");
            if (pattern != null && pattern.length() > 0) {
                if (isReference && matchRule == ISearchEngine.MatchRule.CAMEL_CASE) {
                    H2Index.warn("MatchRule.CAMEL_CASE is not supported by element references search.");
                    matchRule = ISearchEngine.MatchRule.EXACT;
                }
                if (matchRule == ISearchEngine.MatchRule.EXACT) {
                    query.append(" AND NAME='").append(pattern).append('\'');
                } else if (matchRule == ISearchEngine.MatchRule.PREFIX) {
                    query.append(" AND NAME LIKE '").append(this.escapeBackslash(pattern)).append("%'");
                } else if (matchRule == ISearchEngine.MatchRule.CAMEL_CASE) {
                    query.append(" AND CC_NAME LIKE '").append(this.escapeBackslash(pattern)).append("%'");
                } else if (matchRule == ISearchEngine.MatchRule.SET) {
                    String[] patternSet = SEPARATOR_PATTERN.split(pattern);
                    query.append(" AND NAME IN (");
                    int i = 0;
                    while (i < patternSet.length) {
                        if (i > 0) {
                            query.append(',');
                        }
                        query.append('\'').append(patternSet[i]).append('\'');
                        ++i;
                    }
                    query.append(')');
                } else if (matchRule == ISearchEngine.MatchRule.PATTERN) {
                    query.append(" AND NAME LIKE '").append(this.escapeBackslash(pattern).replace('*', '%').replace('?', '_')).append("'");
                }
            }
            if (trueFlags != 0) {
                query.append(" AND BITAND(FLAGS,").append(trueFlags).append(") <> 0");
            }
            if (falseFlags != 0) {
                query.append(" AND BITAND(FLAGS,").append(falseFlags).append(") = 0");
            }
            if (qualifier != null && qualifier.length() > 0) {
                query.append(" AND QUALIFIER='").append(qualifier).append('\'');
            }
            if (parent != null && parent.length() > 0) {
                query.append(" AND PARENT='").append(parent).append('\'');
            }
            if (filesId != null) {
                query.append(" AND FILE_ID IN(");
                int i = 0;
                while (i < filesId.length) {
                    if (i > 0) {
                        query.append(",");
                    }
                    query.append(filesId[i]);
                    ++i;
                }
                query.append(")");
            } else if (containersId != null) {
                query.append(" AND FILE_ID IN(SELECT ID FROM FILES WHERE CONTAINER_ID IN(");
                int i = 0;
                while (i < containersId.length) {
                    if (i > 0) {
                        query.append(",");
                    }
                    query.append(containersId[i]);
                    ++i;
                }
                query.append("))");
            }
            if (limit > 0) {
                query.append(" LIMIT ").append(limit);
            }
            query.append(";");
            if (H2Index.DEBUG) {
                System.out.println("Query: " + query.toString());
            }
            ResultSet result = statement.executeQuery(query.toString());
            try {
                while (result.next()) {
                    ++count;
                    if (monitor != null && monitor.isCanceled()) {
                        return;
                    }
                    int columnIndex = 0;
                    result.getInt(++columnIndex);
                    int f = 0;
                    if (!isReference) {
                        f = result.getInt(++columnIndex);
                    }
                    int offset = result.getInt(++columnIndex);
                    int length = result.getInt(++columnIndex);
                    int nameOffset = 0;
                    int nameLength = 0;
                    if (!isReference) {
                        nameOffset = result.getInt(++columnIndex);
                        nameLength = result.getInt(++columnIndex);
                    }
                    String name = result.getString(++columnIndex);
                    String camelCaseName = null;
                    if (!isReference) {
                        camelCaseName = result.getString(++columnIndex);
                    }
                    String metadata = result.getString(++columnIndex);
                    qualifier = result.getString(++columnIndex);
                    if (!isReference) {
                        parent = result.getString(++columnIndex);
                    }
                    int fileId = result.getInt(++columnIndex);
                    Element element = new Element(elementType, f, offset, length, nameOffset, nameLength, this.modelManager.intern(name), camelCaseName, metadata, qualifier, parent, fileId, isReference);
                    if (!isReference) {
                        H2Cache.addElement(element);
                    }
                    handler.handle(element);
                }
            }
            finally {
                result.close();
            }
        }
        finally {
            statement.close();
        }
        if (H2Index.DEBUG) {
            System.out.println("Results = " + count + " ; Time taken = " + (System.currentTimeMillis() - timeStamp) + " ms.");
        }
    }
}

