/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dlkt.javascript.dom.support.internal;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.dlkt.javascript.dom.support.IDesignTimeDOMProvider;
import org.eclipse.dlkt.javascript.dom.support.IProposalHolder;
import org.eclipse.dlkt.javascript.dom.support.internal.DomResolverSupport;
import org.eclipse.dlkt.javascript.dom.support.internal.ReferenceScope;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.javascript.reference.resolvers.IReferenceResolver;
import org.eclipse.dltk.internal.javascript.reference.resolvers.IResolvableReference;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.typeinference.AbstractCallResultReference;
import org.eclipse.dltk.internal.javascript.typeinference.CompletionString;
import org.eclipse.dltk.internal.javascript.typeinference.IClassReference;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.IReferenceLocation;
import org.eclipse.dltk.internal.javascript.typeinference.ReferenceFactory;
import org.eclipse.dltk.internal.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.internal.javascript.typeinference.ScriptableScopeReference;
import org.eclipse.dltk.internal.javascript.typeinference.StandardSelfCompletingReference;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeJavaTopPackage;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMResolver
implements IReferenceResolver {
    IDesignTimeDOMProvider[] providers;
    ISourceModule module;
    private WeakReference<Map<String, Class<Scriptable>>> classRef;
    private ReferenceResolverContext owner;

    public Set<IReference> getChilds(IResolvableReference ref) {
        Map<String, Class<Scriptable>> classRef = this.getClassMap();
        HashSet<IReference> result = new HashSet<IReference>();
        if (ref instanceof AbstractCallResultReference) {
            AbstractCallResultReference cm = (AbstractCallResultReference)ref;
            Class<Scriptable> clzz = classRef.get(cm.getId());
            if (clzz != null) {
                Method[] methods = clzz.getMethods();
                int a = 0;
                while (a < methods.length) {
                    StandardSelfCompletingReference r;
                    String string = "jsFunction_";
                    String stringget = "jsGet_";
                    String stringset = "jsSet_";
                    Method method = methods[a];
                    if (method.getName().startsWith(string)) {
                        r = new StandardSelfCompletingReference(method.getName().substring(string.length()), true);
                        result.add((IReference)r);
                        r.setFunctionRef();
                    } else if (method.getName().startsWith(stringget)) {
                        r = new StandardSelfCompletingReference(method.getName().substring(stringget.length()), true);
                        result.add((IReference)r);
                    } else if (method.getName().startsWith(stringset)) {
                        r = new StandardSelfCompletingReference(method.getName().substring(stringset.length()), true);
                        result.add((IReference)r);
                    }
                    ++a;
                }
            }
            result.addAll(this.resolveGlobals(String.valueOf(cm.getId()) + "."));
        } else if (ref instanceof ScriptableScopeReference) {
            ScriptableScopeReference ssr = (ScriptableScopeReference)ref;
            Scriptable scriptable = ssr.getScriptable();
            HashMap<String, Object> results = new HashMap<String, Object>();
            this.fillMap(results, scriptable, false, null);
            HashSet<IReference> rs = new HashSet<IReference>();
            this.createReferences("", results, rs);
            return rs;
        }
        return result;
    }

    public Map<String, Class<Scriptable>> getClassMap() {
        Map object;
        if (this.classRef != null && (object = (Map)this.classRef.get()) != null) {
            return object;
        }
        HashMap<String, Class<Scriptable>> mp = new HashMap<String, Class<Scriptable>>();
        int a = 0;
        while (a < this.providers.length) {
            Class<Scriptable>[] resolveHostObjectClasses;
            if (this.providers[a].canResolve(this.module) && (resolveHostObjectClasses = this.providers[a].resolveHostObjectClasses(this.module)) != null) {
                int b = 0;
                while (b < resolveHostObjectClasses.length) {
                    Class<Scriptable> class1 = resolveHostObjectClasses[b];
                    try {
                        Scriptable dc = class1.newInstance();
                        mp.put(dc.getClassName(), class1);
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    ++b;
                }
            }
            ++a;
        }
        this.classRef = new WeakReference(mp);
        return mp;
    }

    private Map<String, Object> getGlobalMap(String key) {
        HashMap<String, Object> mp = new HashMap<String, Object>();
        int a = 0;
        while (a < this.providers.length) {
            Scriptable resolveTopLevelScope;
            if (this.providers[a].canResolve(this.module) && (resolveTopLevelScope = this.providers[a].resolveTopLevelScope(this.module)) != null) {
                this.fillMap(mp, resolveTopLevelScope, true, key);
            }
            ++a;
        }
        return mp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void fillMap(Map<String, Object> mp, Scriptable scope, boolean walkParent, String idToFind) {
        String returnType = null;
        if (scope instanceof IProposalHolder && (returnType = ((IProposalHolder)scope).getReturnType()) != null) {
            IReference typeReference = ReferenceFactory.createTypeReference((String)idToFind, (String)returnType, (ReferenceResolverContext)this.owner);
            if (typeReference instanceof ScriptableScopeReference) {
                Scriptable resolved = ((ScriptableScopeReference)typeReference).getScriptable();
                if (!(resolved instanceof IProposalHolder) || !returnType.equals(((IProposalHolder)resolved).getReturnType())) {
                    scope = resolved;
                }
            } else {
                for (IReference ref : typeReference.getChilds(true)) {
                    if (idToFind != null && !ref.getName().equals(idToFind)) continue;
                    mp.put(ref.getName(), new ReferenceScope(ref));
                }
                if (mp.size() > 0) {
                    return;
                }
            }
        }
        try {
            Scriptable parentScope;
            Context.enter();
            Scriptable prototype = scope.getPrototype();
            if (prototype != null) {
                this.fillMap(mp, prototype, walkParent, idToFind);
                if (idToFind != null && mp.size() == 1) {
                    return;
                }
            }
            if (walkParent && (parentScope = scope.getParentScope()) != null) {
                this.fillMap(mp, parentScope, walkParent, idToFind);
                if (idToFind != null && mp.size() == 1) {
                    return;
                }
            }
            Object[] allIds = null;
            int a = 0;
            while (a < this.providers.length) {
                if (this.providers[a].canResolve(this.module) && (allIds = this.providers[a].resolveIds(scope, idToFind)) != null) break;
                ++a;
            }
            if (allIds == null) {
                allIds = scope instanceof ScriptableObject ? ((ScriptableObject)scope).getAllIds() : scope.getIds();
            }
            int b = 0;
            while (b < allIds.length) {
                String key = allIds[b].toString();
                if (idToFind == null || idToFind.equals(key)) {
                    try {
                        Object object = null;
                        int a2 = 0;
                        while (!(a2 >= this.providers.length || this.providers[a2].canResolve(this.module) && (object = this.providers[a2].getProposal(scope, key)) != null)) {
                            ++a2;
                        }
                        if (object == null) {
                            object = scope.get(key, scope);
                        }
                        mp.put(key, object);
                        if (idToFind != null) {
                            return;
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                ++b;
            }
            return;
        }
        finally {
            Context.exit();
        }
    }

    public void init(ReferenceResolverContext owner) {
        this.owner = owner;
        this.module = owner.getModule();
        this.providers = DomResolverSupport.getProviders();
    }

    public void processCall(String call, String objId) {
    }

    /*
     * Unable to fully structure code
     */
    public Set<IReference> resolveGlobals(String completion) {
        block4: {
            pos = (completion = CompletionString.parse((String)completion, (boolean)true)).indexOf(46);
            key = pos == -1 ? completion : completion.substring(0, pos);
            globals = this.getGlobalMap(pos == -1 ? null : key);
            clss = this.getClassMap();
            rs = new HashSet<IReference>();
            if (pos != -1) ** GOTO lbl25
            this.createReferences(key, globals, rs);
            for (String s : clss.keySet()) {
                if (!s.startsWith(key)) continue;
                rs.add((IReference)new ClassReference(s, false));
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                object = globals.get(key);
                if (object instanceof IProposalHolder) {
                    object = ((IProposalHolder)object).getObject();
                }
                if ((object = this.getObjectReferenceScope(key, object)) instanceof Scriptable) {
                    key = (pos = (completion = completion.substring(pos + 1)).indexOf(46)) == -1 ? completion : completion.substring(0, pos);
                    sc = (Scriptable)object;
                    globals = new HashMap<String, Object>();
                    this.fillMap(globals, sc, false, (String)(pos == -1 && "[]".equals(key) == false ? null : key));
                    continue;
                }
                globals = new HashMap<String, Object>();
                break;
lbl25:
                // 2 sources

                ** while (pos != -1)
            }
lbl26:
            // 2 sources

            this.createReferences(key, globals, rs);
        }
        return rs;
    }

    void createReferences(String key, Map<String, Object> globals, Set<IReference> rs) {
        for (Map.Entry<String, Object> entry : globals.entrySet()) {
            StandardSelfCompletingReference uref;
            String s = entry.getKey();
            if (!s.startsWith(key)) continue;
            IFile sourceFile = null;
            Object object = entry.getValue();
            Object ref = null;
            if (object instanceof ReferenceScope) {
                ref = ((ReferenceScope)object).getReference();
            } else if (object instanceof Scriptable) {
                uref = new ScriptableScopeReference(s, (Scriptable)object, this.owner);
                if (object instanceof IProposalHolder) {
                    IProposalHolder fapn = (IProposalHolder)object;
                    uref.setParameterNames(fapn.getParameterNames());
                    uref.setProposalInfo(fapn.getProposalInfo());
                    sourceFile = fapn.getSourceFile();
                    uref.setReturnType(fapn.getReturnType());
                    uref.setImageUrl(fapn.getImageURL());
                    if (fapn.isFunctionRef()) {
                        uref.setFunctionRef();
                    }
                }
                ref = uref;
            } else if (object instanceof IProposalHolder) {
                IProposalHolder fapn = (IProposalHolder)object;
                ref = (object = this.getObjectReferenceScope(s, ((IProposalHolder)object).getObject())) instanceof ReferenceScope ? ((ReferenceScope)object).getReference() : new StandardSelfCompletingReference(s, false);
                if (ref instanceof StandardSelfCompletingReference) {
                    StandardSelfCompletingReference uref2 = (StandardSelfCompletingReference)ref;
                    uref2.setParameterNames(fapn.getParameterNames());
                    uref2.setProposalInfo(fapn.getProposalInfo());
                    uref2.setImageUrl(fapn.getImageURL());
                    uref2.setReturnType(fapn.getReturnType());
                    sourceFile = fapn.getSourceFile();
                    object = fapn.getObject();
                    if (fapn.isFunctionRef()) {
                        uref2.setFunctionRef();
                    }
                }
            } else {
                ref = new StandardSelfCompletingReference(s, false);
            }
            if (ref instanceof StandardSelfCompletingReference) {
                uref = (StandardSelfCompletingReference)ref;
                if (!ref.isFunctionRef() && object instanceof Function && !(object instanceof NativeJavaTopPackage)) {
                    uref.setFunctionRef();
                }
                if (sourceFile != null) {
                    IReferenceLocation location = uref.getLocation();
                    if ("js".equalsIgnoreCase(sourceFile.getFileExtension())) {
                        try {
                            ISourceModule sourceFileModule = DLTKCore.createSourceModuleFrom(sourceFile);
                            IModelElement[] children = sourceFileModule.getChildren();
                            ISourceRange nameRange = null;
                            String name = uref.getName();
                            int i = 0;
                            while (i < children.length) {
                                IModelElement child = children[i];
                                if (child instanceof IMember && name.equals(child.getElementName())) {
                                    nameRange = ((IMember)child).getNameRange();
                                    if (child.getElementType() == 9 && uref.isFunctionRef() || child.getElementType() == 8 && !uref.isFunctionRef()) break;
                                }
                                ++i;
                            }
                            if (nameRange != null) {
                                location = new ReferenceLocation((IModelElement)sourceFileModule, nameRange.getOffset(), nameRange.getLength());
                            }
                        }
                        catch (ModelException modelException) {}
                    }
                    ref.setLocationInformation(location);
                } else if (uref.getLocation() != null) {
                    ref.setLocationInformation(uref.getLocation());
                } else {
                    ref.setLocationInformation((IReferenceLocation)new ReferenceLocation((IModelElement)this.module, 0, 0));
                }
            }
            rs.add((IReference)ref);
        }
    }

    private Object getObjectReferenceScope(String s, Object object) {
        if (object == null) {
            return null;
        }
        StandardSelfCompletingReference uref = null;
        Class clz = object.getClass();
        if (object instanceof NativeJavaObject) {
            clz = ((NativeJavaObject)object).unwrap().getClass();
        } else if (object instanceof NativeJavaMethod) {
            MemberBox[] methods = ((NativeJavaMethod)object).getMethods();
            int i = 0;
            while (i < methods.length) {
                if (methods[i].getReturnType() != null) {
                    clz = methods[i].getReturnType();
                    break;
                }
                ++i;
            }
        }
        if (clz == String.class) {
            uref = ReferenceFactory.createStringReference((String)s);
        } else if (clz == Boolean.class || clz == Boolean.TYPE) {
            uref = ReferenceFactory.createBooleanReference((String)s);
        } else if (Date.class.isAssignableFrom(clz)) {
            uref = ReferenceFactory.createDateReference((String)s);
        } else if (Number.class.isAssignableFrom(clz) || clz.isPrimitive()) {
            uref = ReferenceFactory.createNumberReference((String)s);
        } else if (clz.isArray()) {
            uref = ReferenceFactory.createArrayReference((String)s);
        }
        if (uref != null) {
            return new ReferenceScope((IReference)uref);
        }
        return object;
    }

    public boolean canResolve(ISourceModule module) {
        return true;
    }

    static final class ClassReference
    extends StandardSelfCompletingReference
    implements IClassReference {
        private ClassReference(String paramOrVarName, boolean childIsh) {
            super(paramOrVarName, childIsh);
        }
    }
}

