/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.internal.javascript.ti.IValueReference;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.parser.JavaScriptParser;
import org.eclipse.dltk.javascript.parser.Reporter;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptValidations {
    public static Script parse(IBuildContext context) {
        IModuleDeclaration declaration;
        String parserId;
        ISourceModule module = context.getSourceModule();
        if (module != null && !"org.eclipse.dltk.javascript.NewParser".equals(parserId = module.getScriptProject().getOption("org.eclipse.dltk.core.sourceParserId", false))) {
            return null;
        }
        IModuleDeclaration savedAST = (IModuleDeclaration)context.get(IBuildContext.ATTR_MODULE_DECLARATION);
        if (savedAST instanceof Script) {
            return (Script)savedAST;
        }
        if (module != null && (declaration = SourceParserUtil.parse((ISourceModule)module, (IProblemReporter)context.getProblemReporter())) instanceof Script) {
            context.set(IBuildContext.ATTR_MODULE_DECLARATION, (Object)declaration);
            return (Script)declaration;
        }
        JavaScriptParser parser = new JavaScriptParser();
        if (module == null) {
            parser.setTypeInformationEnabled(true);
        }
        Script script = parser.parse((IModuleSource)context, context.getProblemReporter());
        context.set(IBuildContext.ATTR_MODULE_DECLARATION, (Object)script);
        return script;
    }

    public static Type typeOf(IValueReference reference) {
        if (reference != null) {
            if (reference.getDeclaredType() != null) {
                return reference.getDeclaredType();
            }
            Set<Type> types = reference.getTypes();
            if (types.size() == 1) {
                return types.toArray(new Type[1])[0];
            }
        }
        return null;
    }

    protected static Reporter createReporter(IBuildContext context) {
        return new Reporter(context.getLineTracker(), context.getProblemReporter());
    }

    public static <E extends Element> List<E> extractElements(IValueReference reference, Class<E> elementType) {
        Object value = reference.getAttribute("ELEMENT");
        if (elementType.isInstance(value)) {
            return Collections.singletonList((Element)value);
        }
        if (value instanceof Element[]) {
            Element[] elements = (Element[])value;
            ArrayList<Element> result = null;
            Element[] elementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Element element = elementArray[n2];
                if (elementType.isInstance(element)) {
                    if (result == null) {
                        result = new ArrayList<Element>(elements.length);
                    }
                    result.add(element);
                }
                ++n2;
            }
            return result;
        }
        return null;
    }
}

