/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text.completion;

import java.net.URL;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.internal.javascript.reference.resolvers.SelfCompletingReference;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Property;
import org.eclipse.dltk.javascript.ui.typeinfo.ElementLabelProviderRegistry;
import org.eclipse.dltk.ui.text.completion.CompletionProposalLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;

public class JavaScriptCompletionProposalLabelProvider
extends CompletionProposalLabelProvider {
    protected String createMethodProposalLabel(CompletionProposal methodProposal) {
        Method method;
        String returnType = null;
        if (methodProposal.getExtraInfo() instanceof SelfCompletingReference) {
            SelfCompletingReference cm = (SelfCompletingReference)methodProposal.getExtraInfo();
            returnType = cm.getReturnType();
        } else if (methodProposal.getExtraInfo() instanceof Method && (method = (Method)methodProposal.getExtraInfo()).getType() != null) {
            returnType = method.getType().getName();
        }
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(methodProposal.getName());
        nameBuffer.append('(');
        this.appendParameterList(nameBuffer, methodProposal);
        nameBuffer.append(')');
        if (returnType != null) {
            nameBuffer.append(": ");
            nameBuffer.append(returnType);
        }
        return nameBuffer.toString();
    }

    protected String createFieldProposalLabel(CompletionProposal proposal) {
        Property property;
        if (proposal.getExtraInfo() instanceof Property && (property = (Property)proposal.getExtraInfo()).getType() != null && !property.getType().getName().equalsIgnoreCase(proposal.getName())) {
            return String.valueOf(proposal.getName()) + ": " + property.getType().getName();
        }
        return proposal.getName();
    }

    public ImageDescriptor createImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = this.extraImageFromProposal(proposal);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createImageDescriptor(proposal);
    }

    private ImageDescriptor extraImageFromProposal(CompletionProposal proposal) {
        ImageDescriptor descriptor;
        if (proposal.getExtraInfo() instanceof SelfCompletingReference) {
            SelfCompletingReference cm = (SelfCompletingReference)proposal.getExtraInfo();
            URL imageUrl = cm.getImageURL();
            if (imageUrl != null) {
                return this.decorateImageDescriptor(ImageDescriptor.createFromURL((URL)imageUrl), proposal);
            }
        } else if (proposal.getExtraInfo() instanceof Element && (descriptor = ElementLabelProviderRegistry.getImageDescriptor((Element)proposal.getExtraInfo())) != null) {
            return this.decorateImageDescriptor(descriptor, proposal);
        }
        return null;
    }

    protected ImageDescriptor createFieldImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = this.extraImageFromProposal(proposal);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createFieldImageDescriptor(proposal);
    }

    protected ImageDescriptor createLocalImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = this.extraImageFromProposal(proposal);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createLocalImageDescriptor(proposal);
    }

    public ImageDescriptor createMethodImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = this.extraImageFromProposal(proposal);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createMethodImageDescriptor(proposal);
    }

    protected ImageDescriptor createPackageImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = this.extraImageFromProposal(proposal);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createPackageImageDescriptor(proposal);
    }

    protected ImageDescriptor createTypeImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = this.extraImageFromProposal(proposal);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createTypeImageDescriptor(proposal);
    }
}

