/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text.folding;

import java.util.HashMap;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.corext.SourceRange;
import org.eclipse.dltk.internal.javascript.validation.AbstractNavigationVisitor;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.Method;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.internal.ui.text.folding.JavaScriptFoldingBlockKind;
import org.eclipse.dltk.javascript.parser.JavaScriptParser;
import org.eclipse.dltk.ui.text.folding.IFoldingBlockKind;
import org.eclipse.dltk.ui.text.folding.IFoldingBlockProvider;
import org.eclipse.dltk.ui.text.folding.IFoldingBlockRequestor;
import org.eclipse.dltk.ui.text.folding.IFoldingContent;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptCodeFoldingBlockProvider
extends AbstractNavigationVisitor<Object>
implements IFoldingBlockProvider {
    private boolean collapseMethods;
    private IFoldingBlockRequestor requestor;
    private MethodCollector methodCollector = new MethodCollector();

    private static Script parse(IFoldingContent content) {
        IModuleDeclaration declaration;
        if (content.getModelElement() instanceof ISourceModule && (declaration = SourceParserUtil.parse((ISourceModule)((ISourceModule)content.getModelElement()), null)) instanceof Script) {
            return (Script)declaration;
        }
        JavaScriptParser parser = new JavaScriptParser();
        parser.setTypeInformationEnabled(true);
        return parser.parse((IModuleSource)content, null);
    }

    public void initializePreferences(IPreferenceStore preferenceStore) {
        this.collapseMethods = preferenceStore.getBoolean("editor_folding_init_methods");
    }

    public int getMinimalLineCount() {
        return 0;
    }

    public void setRequestor(IFoldingBlockRequestor requestor) {
        this.requestor = requestor;
    }

    public void computeFoldableBlocks(IFoldingContent content) {
        Script script = JavaScriptCodeFoldingBlockProvider.parse(content);
        if (script != null) {
            block3: {
                this.methodCollector.clear();
                try {
                    content.getModelElement().accept((IModelElementVisitor)this.methodCollector);
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
            this.visitScript(script);
        }
    }

    public Object visitFunctionStatement(FunctionStatement node) {
        IModelElement element = null;
        Identifier name = node.getName();
        if (name != null) {
            element = this.methodCollector.get(name.sourceStart(), name.sourceEnd() - name.sourceStart());
        }
        this.requestor.acceptBlock(node.sourceStart(), node.sourceEnd(), (IFoldingBlockKind)JavaScriptFoldingBlockKind.FUNCTION, (Object)element, this.collapseMethods);
        return super.visitFunctionStatement(node);
    }

    protected Object visitMethod(Method method) {
        this.requestor.acceptBlock(method.sourceStart(), method.sourceEnd(), (IFoldingBlockKind)JavaScriptFoldingBlockKind.FUNCTION, null, this.collapseMethods);
        return super.visitMethod(method);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodCollector
    extends HashMap<ISourceRange, IModelElement>
    implements IModelElementVisitor {
        public boolean visit(IModelElement element) {
            if (element instanceof IMethod) {
                try {
                    this.put(((IMethod)element).getNameRange(), element);
                }
                catch (ModelException modelException) {}
            }
            return true;
        }

        public IModelElement get(int offset, int length) {
            return (IModelElement)this.get(new SourceRange(offset, length));
        }
    }
}

