/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.xotcl.internal.core.parser.structure;

import java.util.ArrayList;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.tcl.ast.Node;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.structure.AbstractTclCommandModelBuilder;
import org.eclipse.dltk.tcl.structure.ITclModelBuildContext;
import org.eclipse.dltk.tcl.structure.ITclTypeHandler;
import org.eclipse.dltk.tcl.structure.ITclTypeResolver;
import org.eclipse.dltk.xotcl.internal.core.parser.structure.XOTclNames;

public class XOTclClassCreate
extends AbstractTclCommandModelBuilder {
    public boolean process(TclCommand command, ITclModelBuildContext context) {
        int index = 0;
        if (index >= command.getArguments().size()) {
            this.report(context, (Node)command, "Incorrect XOTcl class declaration", 1);
            return false;
        }
        TclArgument name = (TclArgument)command.getArguments().get(index++);
        if (XOTclClassCreate.isSymbol((TclArgument)name) && "create".equals(XOTclClassCreate.asSymbol((TclArgument)name))) {
            if (index >= command.getArguments().size()) {
                this.report(context, (Node)command, "Incorrect XOTcl class declaration", 1);
                return false;
            }
            name = (TclArgument)command.getArguments().get(index++);
        }
        if (!XOTclClassCreate.isSymbol((TclArgument)name)) {
            this.report(context, (Node)command, "A name or 'create' command expected.", 1);
            return false;
        }
        ArrayList<String> superclasses = new ArrayList<String>();
        ArrayList fields = new ArrayList();
        while (index < command.getArguments().size()) {
            TclArgument argument = (TclArgument)command.getArguments().get(index++);
            if (!XOTclClassCreate.isSymbol((TclArgument)argument)) continue;
            String optionName = XOTclClassCreate.asSymbol((TclArgument)argument);
            if ("-superclass".equals(optionName)) {
                if (index >= command.getArguments().size()) continue;
                TclArgument sc = (TclArgument)command.getArguments().get(index++);
                superclasses.add(XOTclClassCreate.asSymbol((TclArgument)sc));
                continue;
            }
            if (!"-parameter".equals(optionName) || index >= command.getArguments().size()) continue;
            this.parseRawParameters((TclArgument)command.getArguments().get(index++), fields);
        }
        IElementRequestor.TypeInfo ti = new IElementRequestor.TypeInfo();
        ti.declarationStart = command.getStart();
        ti.nameSourceStart = name.getStart();
        ti.nameSourceEnd = name.getEnd() - 1;
        ti.name = XOTclClassCreate.asSymbol((TclArgument)name);
        ti.superclasses = superclasses.toArray(new String[superclasses.size()]);
        ti.modifiers = 0x100000;
        ITclTypeHandler typeHanlder = ((ITclTypeResolver)context.get(ITclTypeResolver.class)).resolveType(ti, command.getEnd(), ti.name);
        XOTclNames.create(context).addType(typeHanlder);
        for (AbstractTclCommandModelBuilder.Parameter parameter : fields) {
            IElementRequestor.FieldInfo fi = new IElementRequestor.FieldInfo();
            fi.name = parameter.getName();
            fi.nameSourceStart = parameter.getStart();
            fi.nameSourceEnd = parameter.getEnd() - 1;
            fi.declarationStart = fi.nameSourceStart;
            if (!context.getRequestor().enterFieldCheckDuplicates(fi)) continue;
            context.getRequestor().exitField(fi.nameSourceEnd);
        }
        typeHanlder.leave(context.getRequestor());
        return false;
    }
}

