/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.parser;

import com.xored.org.mozilla.javascript.CompilerEnvirons;
import com.xored.org.mozilla.javascript.FunctionNode;
import com.xored.org.mozilla.javascript.Parser;
import com.xored.org.mozilla.javascript.ScriptOrFnNode;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.javascript.parser.JavaScriptErrorReporter;
import org.eclipse.dltk.internal.javascript.parser.JavaScriptModuleDeclaration;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ResolverManager;
import org.eclipse.dltk.internal.javascript.typeinference.ContextReference;
import org.eclipse.dltk.internal.javascript.typeinference.HostCollection;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.IReferenceLocation;
import org.eclipse.dltk.internal.javascript.typeinference.StandardSelfCompletingReference;
import org.eclipse.dltk.internal.javascript.typeinference.TypeInferencer;
import org.eclipse.dltk.javascript.core.JavaScriptCorePreferences;

public class JavaScriptSourceElementParser
implements ISourceElementParser {
    protected ISourceElementRequestor fRequestor = null;
    protected IProblemReporter fReporter = null;
    private ISourceModule module;
    private Set<IReference> reportedRefs = new HashSet<IReference>();

    public void parseSourceModule(IModuleSource module) {
        if (module instanceof ISourceModule) {
            this.module = (ISourceModule)module;
        }
        this.parseSourceModule(module.getSourceContents());
    }

    private void parseSourceModule(String content) {
        CompilerEnvirons cenv = new CompilerEnvirons();
        cenv.setStrictMode(JavaScriptCorePreferences.isStrictMode());
        JavaScriptModuleDeclaration moduleDeclaration = new JavaScriptModuleDeclaration(content.length());
        Parser parser = new Parser(cenv, new JavaScriptErrorReporter(this.fReporter));
        try {
            ReferenceResolverContext resolverContext;
            ScriptOrFnNode parse = parser.parse(new StringReader(content), "", 0);
            if (this.module != null) {
                resolverContext = ResolverManager.createResolverContext(this.module, Collections.emptyMap(), true);
                resolverContext.init();
            } else {
                resolverContext = new ReferenceResolverContext(null, Collections.emptyMap());
            }
            TypeInferencer interferencer = new TypeInferencer((ModelElement)this.module, resolverContext);
            interferencer.setRequestor(this.fRequestor);
            interferencer.doInterferencing(parse, Integer.MAX_VALUE);
            this.fRequestor.enterModule();
            HostCollection collection = interferencer.getCollection();
            this.processNode(parse, collection);
            moduleDeclaration.setCollection(collection);
            for (IReference ref : collection.getReferences().values()) {
                this.reportRef(ref, null, 0);
            }
            Map<Integer, HostCollection> ms = interferencer.getFunctionMap();
            moduleDeclaration.setFunctionMap(ms);
            for (HostCollection next : ms.values()) {
                this.fRequestor.acceptFieldReference("!!!" + next.getName(), 0);
            }
            this.fRequestor.exitModule(content.length());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void reportRef(IReference ref, String sma, int level) {
        if (this.reportedRefs.contains(ref)) {
            return;
        }
        this.reportedRefs.add(ref);
        String key = ref.getName();
        if (sma != null) {
            key = String.valueOf(sma) + '.' + key;
        }
        if (level == 0) {
            Set<IReference> sm = ref.getChilds(false);
            for (IReference refa : sm) {
                this.reportRef(refa, key, level + 1);
            }
        }
        this.fRequestor.acceptFieldReference(key, 0);
    }

    private void processNode(ScriptOrFnNode parse, HostCollection collection) {
        FunctionNode n;
        int a = 0;
        while (a < parse.getFunctionCount()) {
            FunctionNode functionNode = parse.getFunctionNode(a);
            functionNode.getFunctionName();
            HostCollection function = collection != null ? collection.getFunction(functionNode) : null;
            String functionName = functionNode.getFunctionName();
            if (functionName.length() != 0) {
                IElementRequestor.MethodInfo methodInfo = new IElementRequestor.MethodInfo();
                methodInfo.name = functionName;
                methodInfo.declarationStart = functionNode.getEncodedSourceStart();
                String[] paramsAndVars = functionNode.getParamAndVarNames();
                String[] params = new String[functionNode.getParamCount()];
                int i = 0;
                while (i < params.length) {
                    params[i] = paramsAndVars[i];
                    ++i;
                }
                methodInfo.parameterNames = params;
                methodInfo.nameSourceStart = functionNode.nameStart + 1;
                methodInfo.nameSourceEnd = functionNode.nameEnd + 1;
                this.fRequestor.enterMethod(methodInfo);
                this.processNode(functionNode, function);
                this.fRequestor.exitMethod(functionNode.getEncodedSourceEnd());
            }
            ++a;
        }
        String[] paramsAndVars = parse.getParamAndVarNames();
        String[] params = new String[parse.getParamCount()];
        int i = 0;
        while (i < params.length) {
            params[i] = paramsAndVars[i];
            ++i;
        }
        int of = 0;
        if (parse instanceof FunctionNode && (n = (FunctionNode)parse).getFunctionType() != 1) {
            of = 1;
        }
        int i2 = params.length;
        while (i2 < paramsAndVars.length - of) {
            IElementRequestor.FieldInfo fieldInfo = new IElementRequestor.FieldInfo();
            fieldInfo.name = paramsAndVars[i2];
            ScriptOrFnNode.Position p = parse.getPosition(i2);
            fieldInfo.nameSourceStart = p.start + 1;
            fieldInfo.nameSourceEnd = p.start + fieldInfo.name.length();
            fieldInfo.declarationStart = p.start;
            this.fRequestor.enterField(fieldInfo);
            if (collection != null) {
                IReference reference = collection.getReference(fieldInfo.name);
                if (reference != null) {
                    Set<IReference> childs = reference.getChilds(false);
                    for (IReference ref : childs) {
                        if (ref instanceof StandardSelfCompletingReference) {
                            StandardSelfCompletingReference uref = (StandardSelfCompletingReference)ref;
                            if (ref.isFunctionRef()) {
                                this.reportMethod(ref.getName(), uref.getLocation());
                                continue;
                            }
                            this.reportField(ref.getName(), uref.getLocation());
                            continue;
                        }
                        if (!(ref instanceof ContextReference)) continue;
                        ContextReference rr = (ContextReference)ref;
                        this.reportMethod(rr.getName(), rr.getLocation());
                    }
                }
            } else {
                this.fRequestor.exitField(fieldInfo.nameSourceEnd);
            }
            ++i2;
        }
    }

    private void reportMethod(String methodName, IReferenceLocation location) {
        IElementRequestor.MethodInfo mi = new IElementRequestor.MethodInfo();
        mi.name = methodName;
        mi.parameterNames = CharOperation.NO_STRINGS;
        mi.declarationStart = location.getOffset();
        mi.nameSourceStart = location.getOffset();
        mi.nameSourceEnd = location.getOffset() + location.getLength() - 1;
        this.fRequestor.enterMethod(mi);
        this.fRequestor.exitMethod(location.getOffset() + location.getLength());
    }

    private void reportField(String fieldName, IReferenceLocation location) {
        IElementRequestor.FieldInfo fi = new IElementRequestor.FieldInfo();
        fi.name = fieldName;
        fi.nameSourceStart = location.getOffset();
        fi.nameSourceEnd = location.getOffset() + location.getLength() - 1;
        fi.declarationStart = location.getOffset();
        this.fRequestor.enterField(fi);
        this.fRequestor.exitField(location.getOffset() + location.getLength());
    }

    public void setRequestor(ISourceElementRequestor requestor) {
        this.fRequestor = requestor;
    }

    public void setReporter(IProblemReporter reporter) {
        this.fReporter = reporter;
    }
}

