/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.parser.structure;

import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.internal.javascript.parser.structure.StructureReporter;
import org.eclipse.dltk.internal.javascript.ti.IValueReference;
import org.eclipse.dltk.internal.javascript.ti.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.model.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Declaration
implements Comparable<Declaration> {
    final String childName;
    final IValueReference child;

    public Declaration(String childName, IValueReference child) {
        this.childName = childName;
        this.child = child;
    }

    @Override
    public int compareTo(Declaration o) {
        return this.child.getLocation().getNameStart() - o.child.getLocation().getNameStart();
    }

    abstract void report(StructureReporter var1);

    protected static String extractType(IValueReference reference) {
        return reference != null ? Declaration.extractType(reference.getDeclaredType()) : null;
    }

    protected static String extractType(Type type) {
        return type != null ? type.getName() : null;
    }

    protected static void copyLocation(ReferenceLocation location, IElementRequestor.ElementInfo info) {
        info.declarationStart = location.getDeclarationStart();
        info.nameSourceStart = location.getNameStart();
        info.nameSourceEnd = location.getNameEnd() - 1;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "<" + this.childName + ">=" + this.child;
    }
}

