/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import org.eclipse.dltk.internal.javascript.ti.AbstractReference;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.IValueCollection;
import org.eclipse.dltk.internal.javascript.ti.IValueProvider;
import org.eclipse.dltk.internal.javascript.ti.IValueReference;

public class ChildReference
extends AbstractReference {
    private final IValueProvider parent;
    private final String name;

    public ChildReference(IValueProvider parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public boolean isReference() {
        if ("()".equals(this.name) || "[]".equals(this.name)) {
            return false;
        }
        return this.parent.isReference();
    }

    public IValue getValue() {
        if (this.parent instanceof IValueCollection) {
            return ChildReference.findChild((IValueCollection)((Object)this.parent), this.name);
        }
        IValue parentValue = this.parent.getValue();
        if (parentValue != null) {
            return parentValue.getChild(this.name, true);
        }
        return null;
    }

    private static IValue findChild(IValueCollection collection, String name) {
        while (collection != null) {
            IValue childValue = ((IValueProvider)((Object)collection)).getValue().getChild(name, true);
            if (childValue != null) {
                return childValue;
            }
            collection = collection.getParent();
        }
        return null;
    }

    public IValue createValue() {
        IValue childValue;
        if (this.parent instanceof IValueCollection && (childValue = ChildReference.findChild((IValueCollection)((Object)this.parent), this.name)) != null) {
            return childValue;
        }
        IValue parentValue = this.parent.createValue();
        if (parentValue != null) {
            return parentValue.createChild(this.name);
        }
        return null;
    }

    public ITypeInferenceContext getContext() {
        return this.parent.getContext();
    }

    public IValueReference getParent() {
        if (this.parent instanceof IValueReference) {
            return (IValueReference)((Object)this.parent);
        }
        return null;
    }

    public void delete() {
        IValue value = this.parent.getValue();
        if (value != null) {
            value.deleteChild(this.name);
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.parent.toString()) + "." + this.name;
    }
}

