/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.internal.javascript.ti.ElementValue;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.ReferenceKind;
import org.eclipse.dltk.internal.javascript.ti.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.model.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Value
implements IValue {
    private final Set<Type> types = new HashSet<Type>();
    private final Map<String, Value> children = new HashMap<String, Value>();
    private final Map<String, IValue> inherited = new HashMap<String, IValue>();
    private Set<String> deletedChildren = null;
    private Type declaredType;
    private ReferenceKind kind = ReferenceKind.UNKNOWN;
    private ReferenceLocation location = ReferenceLocation.UNKNOWN;
    private Map<String, Object> attributes = null;
    private Set<Value> references = new HashSet<Value>();
    private static final Handler<Set<Type>> GET_TYPES = new Handler<Set<Type>>(){

        @Override
        public void process(Value value, Set<Type> result) {
            result.addAll(value.types);
        }
    };
    private static final Handler<Set<Type>> GET_DECLARED_TYPES = new Handler<Set<Type>>(){

        @Override
        public void process(Value value, Set<Type> result) {
            result.addAll(value.types);
        }
    };
    private static final Handler<Set<String>> GET_DIRECT_CHILDREN = new Handler<Set<String>>(){

        @Override
        public void process(Value value, Set<String> result) {
            result.addAll(value.children.keySet());
        }
    };

    private final boolean hasReferences() {
        return !this.references.isEmpty();
    }

    private static <R> void execute(Value value, Handler<R> handler, R result, Set<Value> visited) {
        if (visited.add(value)) {
            handler.process(value, result);
            for (Value child : value.references) {
                Value.execute(child, handler, result, visited);
            }
        }
    }

    @Override
    public Set<Type> getTypes() {
        if (this.hasReferences()) {
            HashSet<Type> result = new HashSet<Type>();
            Value.execute(this, GET_TYPES, result, new HashSet<Value>());
            return result;
        }
        return this.types;
    }

    @Override
    public Type getDeclaredType() {
        if (this.hasReferences()) {
            HashSet result = new HashSet();
            Value.execute(this, GET_DECLARED_TYPES, result, new HashSet<Value>());
            return !result.isEmpty() ? (Type)result.iterator().next() : null;
        }
        return this.declaredType;
    }

    @Override
    public Set<Type> getDeclaredTypes() {
        if (this.hasReferences()) {
            HashSet<Type> result = new HashSet<Type>();
            Value.execute(this, GET_DECLARED_TYPES, result, new HashSet<Value>());
            return result;
        }
        return this.declaredType != null ? Collections.singleton(this.declaredType) : Collections.emptySet();
    }

    @Override
    public void setDeclaredType(Type declaredType) {
        this.declaredType = declaredType;
    }

    @Override
    public ReferenceKind getKind() {
        return this.kind;
    }

    @Override
    public void setKind(ReferenceKind kind) {
        this.kind = kind;
    }

    @Override
    public ReferenceLocation getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(ReferenceLocation location) {
        this.location = location;
    }

    @Override
    public Object getAttribute(String key) {
        if (this.attributes != null) {
            return this.attributes.get(key);
        }
        return null;
    }

    @Override
    public void removeAttribute(String key) {
        if (this.attributes != null) {
            this.attributes.remove(key);
        }
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, value);
    }

    @Override
    public Set<String> getDirectChildren() {
        if (this.hasReferences()) {
            HashSet<String> result = new HashSet<String>();
            Value.execute(this, GET_DIRECT_CHILDREN, result, new HashSet<Value>());
            return result;
        }
        return this.children.keySet();
    }

    @Override
    public Set<String> getDeletedChildren() {
        if (this.deletedChildren != null) {
            return this.deletedChildren;
        }
        return Collections.emptySet();
    }

    @Override
    public void deleteChild(String name) {
        if (this.deletedChildren == null) {
            this.deletedChildren = new HashSet<String>();
        }
        this.deletedChildren.add(name);
    }

    protected IValue findMember(String name, boolean resolve) {
        ElementValue member = ElementValue.findMember(this.declaredType, name);
        if (member != null) {
            return member;
        }
        for (Type type : this.types) {
            member = ElementValue.findMember(type, name);
            if (member == null) continue;
            return member;
        }
        return null;
    }

    @Override
    public IValue getChild(String name, boolean resolve) {
        if (this.hasReferences()) {
            HashSet result = new HashSet();
            Value.execute(this, new GetChildHandler(name), result, new HashSet<Value>());
            if (!result.isEmpty()) {
                return (IValue)result.iterator().next();
            }
            return null;
        }
        IValue child = this.children.get(name);
        if (child == null && (child = this.inherited.get(name)) == null) {
            child = this.findMember(name, resolve);
        }
        return child;
    }

    @Override
    public void putChild(String name, IValue value) {
        this.inherited.put(name, value);
    }

    @Override
    public IValue createChild(String name) {
        IValue child = this.children.get(name);
        if (child == null && (child = this.inherited.get(name)) == null) {
            if (this.hasReferences()) {
                HashSet result = new HashSet();
                Value.execute(this, new CreateChildOperation(name), result, new HashSet<Value>());
                if (!result.isEmpty()) {
                    return (IValue)result.iterator().next();
                }
            }
            child = new Value();
            this.children.put(name, (Value)child);
        }
        return child;
    }

    @Override
    public boolean hasChild(String name) {
        return this.children.containsKey(name) || this.inherited.containsKey(name);
    }

    @Override
    public void clear() {
        this.references.clear();
        this.children.clear();
        this.inherited.clear();
        this.types.clear();
    }

    @Override
    public void addValue(IValue src) {
        if (src instanceof Value) {
            this.addValueRecursive((Value)src, new HashSet<Value>());
        } else {
            if (src.getDeclaredType() != null) {
                this.types.add(src.getDeclaredType());
            }
            this.types.addAll(src.getTypes());
        }
    }

    @Override
    public void addReference(IValue src) {
        assert (src != null);
        if (src == this) {
            return;
        }
        if (src instanceof Value) {
            this.references.add((Value)src);
        }
    }

    private void addValueRecursive(Value src, Set<Value> processing) {
        if (processing.add(src)) {
            if (src.declaredType != null) {
                this.types.add(src.declaredType);
            }
            this.types.addAll(src.types);
            for (Map.Entry<String, Value> entry : src.children.entrySet()) {
                Value child = (Value)this.createChild(entry.getKey());
                if (child == null) continue;
                child.addValueRecursive(entry.getValue(), processing);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CreateChildOperation
    implements Handler<Set<Value>> {
        private final String childName;

        public CreateChildOperation(String childName) {
            this.childName = childName;
        }

        @Override
        public void process(Value value, Set<Value> result) {
            if (result.isEmpty() && !value.hasReferences()) {
                result.add((Value)value.createChild(this.childName));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetChildHandler
    implements Handler<Set<Value>> {
        private final String childName;

        public GetChildHandler(String childName) {
            this.childName = childName;
        }

        @Override
        public void process(Value value, Set<Value> result) {
            Value child = (Value)value.children.get(this.childName);
            if (child != null) {
                result.add(child);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Handler<R> {
        public void process(Value var1, R var2);
    }
}

