/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.javascript.reference.resolvers.IResolvableReference;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.typeinference.HostCollection;
import org.eclipse.dltk.internal.javascript.typeinference.IDoNotReportChilds;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.IReferenceLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCallResultReference
implements IReference,
IDoNotReportChilds,
IResolvableReference {
    private final String id;
    private final String name;
    private final ReferenceResolverContext cs;
    private Set<IReference> hashSet = null;
    private boolean local;
    private static final Set<String> searchIds = new HashSet<String>();

    @Override
    public IReference getChild(String key, boolean resolveLocals) {
        if (!resolveLocals) {
            return null;
        }
        if (this.hashSet == null) {
            this.getChilds(resolveLocals);
        }
        if (this.hashSet == null) {
            return null;
        }
        for (IReference next : this.hashSet) {
            HostCollection hc;
            IReference reference;
            if (next instanceof IReference) {
                IReference r = next;
                if (!r.getName().equals(key)) continue;
                return r;
            }
            if (!(next instanceof HostCollection) || (reference = (hc = (HostCollection)((Object)next)).getReference(key)) == null) continue;
            return reference;
        }
        return null;
    }

    @Override
    public IReference getPrototype(boolean resolveLocals) {
        return this.getChild("prototype", resolveLocals);
    }

    @Override
    public Set<IReference> getChilds(boolean resolveLocals) {
        if (!resolveLocals) {
            return Collections.emptySet();
        }
        if (searchIds.contains(this.id)) {
            return Collections.emptySet();
        }
        if (this.hashSet != null) {
            return this.hashSet;
        }
        try {
            searchIds.add(this.id);
            this.hashSet = this.internalGetChilds(resolveLocals);
        }
        finally {
            searchIds.remove(this.id);
        }
        return this.hashSet;
    }

    protected Set<IReference> internalGetChilds(boolean resolveLocals) {
        return this.cs.resolveChilds(this);
    }

    public abstract String getResultId();

    @Override
    public String getName() {
        return this.name;
    }

    public AbstractCallResultReference(String name, String id2, ReferenceResolverContext cs) {
        this.name = name;
        this.id = id2;
        this.cs = cs;
    }

    @Override
    public boolean isChildishReference() {
        return false;
    }

    @Override
    public void recordDelete(String fieldId) {
    }

    @Override
    public void setChild(String key, IReference ref) {
    }

    @Override
    public void setPrototype(IReference ref) {
    }

    @Override
    public void addModelElements(Collection<IModelElement> toAdd) {
    }

    @Override
    public void setLocationInformation(IReferenceLocation location) {
    }

    public String getId() {
        return this.id;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public void setLocal(boolean local) {
        this.local = local;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.name + "]";
    }
}

