/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.NativeArrayReference;
import org.eclipse.dltk.internal.javascript.typeinference.NativeBooleanReference;
import org.eclipse.dltk.internal.javascript.typeinference.NativeDateReference;
import org.eclipse.dltk.internal.javascript.typeinference.NativeNumberReference;
import org.eclipse.dltk.internal.javascript.typeinference.NativeStringReference;
import org.eclipse.dltk.internal.javascript.typeinference.NativeXMLReference;
import org.eclipse.dltk.internal.javascript.typeinference.ScriptableScopeReference;
import org.eclipse.dltk.internal.javascript.typeinference.StandardSelfCompletingReference;
import org.eclipse.dltk.javascript.typeinference.IScriptableTypeProvider;
import org.eclipse.dltk.javascript.typeinfo.ITypeNames;
import org.mozilla.javascript.Scriptable;

public class ReferenceFactory
implements ITypeNames {
    private static IScriptableTypeProvider[] providers;

    static {
        ReferenceFactory.initProviders();
    }

    private static void initProviders() {
        ArrayList<IScriptableTypeProvider> providerList = new ArrayList<IScriptableTypeProvider>();
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.dltk.javascript.core.customtype");
        int b = 0;
        while (b < configurationElements.length) {
            IConfigurationElement configurationElement = configurationElements[b];
            try {
                Object createExecutableExtension = configurationElement.createExecutableExtension("class");
                if (createExecutableExtension instanceof IScriptableTypeProvider) {
                    providerList.add((IScriptableTypeProvider)createExecutableExtension);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++b;
        }
        providers = providerList.toArray(new IScriptableTypeProvider[providerList.size()]);
    }

    public static IScriptableTypeProvider[] getScriptTypeProviders() {
        return providers;
    }

    public static StandardSelfCompletingReference createNumberReference(String name) {
        return new NativeNumberReference(name);
    }

    public static StandardSelfCompletingReference createStringReference(String name) {
        return new NativeStringReference(name);
    }

    public static StandardSelfCompletingReference createBooleanReference(String name) {
        return new NativeBooleanReference(name);
    }

    public static StandardSelfCompletingReference createArrayReference(String name) {
        return new NativeArrayReference(name);
    }

    public static StandardSelfCompletingReference createDateReference(String name) {
        return new NativeDateReference(name);
    }

    public static StandardSelfCompletingReference createXMLReference(String name) {
        return new NativeXMLReference(name);
    }

    public static IReference createTypeReference(String paramOrVarName, String type, ReferenceResolverContext rrc) {
        if (type != null) {
            if ("Boolean".equalsIgnoreCase(type)) {
                return ReferenceFactory.createBooleanReference(paramOrVarName);
            }
            if ("Number".equalsIgnoreCase(type)) {
                return ReferenceFactory.createNumberReference(paramOrVarName);
            }
            if ("String".equalsIgnoreCase(type)) {
                return ReferenceFactory.createStringReference(paramOrVarName);
            }
            if ("Date".equalsIgnoreCase(type)) {
                return ReferenceFactory.createDateReference(paramOrVarName);
            }
            if ("Array".equalsIgnoreCase(type)) {
                return ReferenceFactory.createArrayReference(paramOrVarName);
            }
            if ("XML".equalsIgnoreCase(type)) {
                return ReferenceFactory.createXMLReference(paramOrVarName);
            }
            if (providers != null) {
                int i = 0;
                while (i < providers.length) {
                    Scriptable ref = providers[i].getType(paramOrVarName, type);
                    if (ref != null) {
                        return new ScriptableScopeReference(paramOrVarName, ref, rrc);
                    }
                    ++i;
                }
            }
        }
        return new StandardSelfCompletingReference(paramOrVarName, false);
    }

    public static IReference createRegExpReference(String name) {
        return new StandardSelfCompletingReference(name, false);
    }
}

