/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ISourceable;
import org.eclipse.dltk.utils.IntList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommaExpression
extends Expression {
    private List<ASTNode> items;
    private IntList commas;

    public CommaExpression(ASTNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.items != null) {
                for (ASTNode node : this.items) {
                    node.traverse(visitor);
                }
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public List<ASTNode> getItems() {
        return this.items;
    }

    public void setItems(List<ASTNode> items) {
        this.items = items;
    }

    public IntList getCommas() {
        return this.commas;
    }

    public void setCommas(IntList commas) {
        this.commas = commas;
    }

    @Override
    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.items.size() == 0 || this.commas.size() == this.items.size() - 1 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.items.size()) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(((ISourceable)this.items.get(i)).toSourceString(indentationString));
            ++i;
        }
        return buffer.toString();
    }
}

