/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser;

import org.antlr.runtime.tree.Tree;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.javascript.parser.JSParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSVisitor<E> {
    protected JSVisitor() {
    }

    protected final E visitNode(Tree node) {
        E accept = this.visit(node);
        if (accept == null) {
            int i = 0;
            while (i < node.getChildCount()) {
                this.visitNode(node.getChild(i));
                ++i;
            }
        }
        return accept;
    }

    protected E visit(Tree node) {
        Assert.isNotNull((Object)node);
        switch (node.getType()) {
            case 17: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 177: {
                return this.visitIdentifier(node);
            }
            case 126: {
                return this.visitBlock(node);
            }
            case 5: 
            case 6: {
                return this.visitBooleanLiteral(node);
            }
            case 25: {
                return this.visitThis(node);
            }
            case 182: {
                return this.visitDecimalLiteral(node);
            }
            case 171: {
                return this.visitStringLiteral(node);
            }
            case 127: {
                return this.visitByField(node);
            }
            case 128: {
                return this.visitByIndex(node);
            }
            case 133: {
                return this.visitExpression(node);
            }
            case 131: {
                return this.visitCall(node);
            }
            case 4: {
                return this.visitNull(node);
            }
            case 20: 
            case 21: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 100: 
            case 101: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                return this.visitBinaryOperation(node);
            }
            case 90: 
            case 91: 
            case 98: 
            case 99: 
            case 143: 
            case 146: 
            case 147: 
            case 148: {
                return this.visitUnaryOperation(node);
            }
            case 23: {
                return this.visitReturn(node);
            }
            case 24: {
                return this.visitSwitch(node);
            }
            case 11: {
                return this.visitDefault(node);
            }
            case 8: {
                return this.visitCase(node);
            }
            case 7: {
                return this.visitBreak(node);
            }
            case 10: {
                return this.visitContinue(node);
            }
            case 13: {
                return this.visitDoWhile(node);
            }
            case 31: {
                return this.visitWhile(node);
            }
            case 16: {
                return this.visitFor(node);
            }
            case 144: {
                return this.visitObjectInitializer(node);
            }
            case 142: {
                return this.visitPropertyInitializer(node);
            }
            case 136: {
                return this.visitForEachInStatement(node);
            }
            case 19: {
                return this.visitIf(node);
            }
            case 102: {
                return this.visitConditional(node);
            }
            case 145: {
                return this.visitParenthesizedExpression(node);
            }
            case 27: {
                return this.visitTry(node);
            }
            case 26: {
                return this.visitThrow(node);
            }
            case 9: {
                return this.visitCatch(node);
            }
            case 15: {
                return this.visitFinally(node);
            }
            case 22: {
                return this.visitNew(node);
            }
            case 125: {
                return this.visitArray(node);
            }
            case 132: {
                return this.visitCommaExpression(node);
            }
            case 178: {
                return this.visitRegExp(node);
            }
            case 32: {
                return this.visitWith(node);
            }
            case 141: {
                return this.visitLabelled(node);
            }
            case 12: {
                return this.visitDelete(node);
            }
            case 30: {
                return this.visitVoid(node);
            }
            case 137: {
                return this.visitGet(node);
            }
            case 138: {
                return this.visitSet(node);
            }
            case 28: {
                return this.visitTypeOf(node);
            }
            case 29: {
                return this.visitVarDeclaration(node);
            }
            case 43: {
                return this.visitConst(node);
            }
            case 18: {
                return this.visitFunction(node);
            }
            case 150: {
                return this.visitXmlLiteral(node);
            }
            case 139: {
                return this.visitNamespace(node);
            }
            case 149: {
                return this.visitXmlAttribute(node);
            }
            case 129: {
                return this.visitGetAllChildren(node);
            }
            case 130: {
                return this.visitGetLocalName(node);
            }
            case 184: {
                return this.visitHexIntegerLiteral(node);
            }
            case 183: {
                return this.visitOctalIntegerLiteral(node);
            }
            case 35: {
                return this.visitYield(node);
            }
            case 151: {
                return this.visitEmptyStatement(node);
            }
        }
        return this.visitUnknown(node);
    }

    protected E visitUnknown(Tree node) {
        throw new UnsupportedOperationException("Unknown token " + JSParser.tokenNames[node.getType()] + " (" + node.getText() + ")");
    }

    protected abstract E visitFunction(Tree var1);

    protected abstract E visitIdentifier(Tree var1);

    protected abstract E visitXmlLiteral(Tree var1);

    protected abstract E visitNamespace(Tree var1);

    protected abstract E visitXmlAttribute(Tree var1);

    protected abstract E visitGetAllChildren(Tree var1);

    protected abstract E visitGetLocalName(Tree var1);

    protected abstract E visitHexIntegerLiteral(Tree var1);

    protected abstract E visitOctalIntegerLiteral(Tree var1);

    protected abstract E visitYield(Tree var1);

    protected abstract E visitBlock(Tree var1);

    protected abstract E visitSwitch(Tree var1);

    protected abstract E visitDefault(Tree var1);

    protected abstract E visitCase(Tree var1);

    protected abstract E visitReturn(Tree var1);

    protected abstract E visitBooleanLiteral(Tree var1);

    protected abstract E visitDecimalLiteral(Tree var1);

    protected abstract E visitStringLiteral(Tree var1);

    protected abstract E visitBinaryOperation(Tree var1);

    protected abstract E visitUnaryOperation(Tree var1);

    protected abstract E visitBreak(Tree var1);

    protected abstract E visitCall(Tree var1);

    protected abstract E visitDoWhile(Tree var1);

    protected abstract E visitWhile(Tree var1);

    protected abstract E visitForEachInStatement(Tree var1);

    protected abstract E visitFor(Tree var1);

    protected abstract E visitExpression(Tree var1);

    protected abstract E visitContinue(Tree var1);

    protected abstract E visitVarDeclaration(Tree var1);

    protected abstract E visitObjectInitializer(Tree var1);

    protected abstract E visitPropertyInitializer(Tree var1);

    protected abstract E visitByField(Tree var1);

    protected abstract E visitByIndex(Tree var1);

    protected abstract E visitIf(Tree var1);

    protected abstract E visitConditional(Tree var1);

    protected abstract E visitParenthesizedExpression(Tree var1);

    protected abstract E visitTry(Tree var1);

    protected abstract E visitCatch(Tree var1);

    protected abstract E visitFinally(Tree var1);

    protected abstract E visitThrow(Tree var1);

    protected abstract E visitNew(Tree var1);

    protected abstract E visitArray(Tree var1);

    protected abstract E visitCommaExpression(Tree var1);

    protected abstract E visitRegExp(Tree var1);

    protected abstract E visitWith(Tree var1);

    protected abstract E visitThis(Tree var1);

    protected abstract E visitLabelled(Tree var1);

    protected abstract E visitDelete(Tree var1);

    protected abstract E visitGet(Tree var1);

    protected abstract E visitSet(Tree var1);

    protected abstract E visitNull(Tree var1);

    protected abstract E visitTypeOf(Tree var1);

    protected abstract E visitConst(Tree var1);

    protected abstract E visitVoid(Tree var1);

    protected abstract E visitEmptyStatement(Tree var1);
}

