/*******************************************************************************
 * Copyright (c) 2010 xored software, Inc.  
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html  
 *
 * Contributors:
 *     xored software, Inc. - initial API and Implementation (Alex Panchenko)
 *******************************************************************************/
package org.eclipse.dltk.javascript.internal.parser;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.Type;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;

public class VariableTypedDeclaration implements ITypedDeclaration {

	private final VariableDeclaration variable;

	public VariableTypedDeclaration(VariableDeclaration variable) {
		this.variable = variable;
	}

	public ASTNode getNode() {
		return variable;
	}

	public void setColonPosition(int colonPosition) {
		variable.setColonPosition(colonPosition);
	}

	public void setType(Type type) {
		variable.setType(type);
	}

}
