/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.log;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.internal.debug.ui.log.Messages;
import org.eclipse.dltk.internal.debug.ui.log.ScriptDebugLogContentProvider;
import org.eclipse.dltk.internal.debug.ui.log.ScriptDebugLogCopyAction;
import org.eclipse.dltk.internal.debug.ui.log.ScriptDebugLogItem;
import org.eclipse.dltk.internal.debug.ui.log.ScriptDebugLogLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.ViewPart;

public class ScriptDebugLogView
extends ViewPart {
    public static final String VIEW_ID = "org.eclipse.dltk.debug.ui.dbgpLogView";
    public static final String THEME_ID = "org.eclipse.dltk.debug.ui.dbgpLogView.txtViewFont";
    private final List items = new ArrayList();
    private TableViewer viewer;
    private TextViewer textViewer;
    private IDocument textDocument;
    private IPropertyChangeListener fontRegistryChangeListener;
    private IAction copyAction;
    private IAction clearAction;

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void createPartControl(Composite parent) {
        SashForm sashForm = new SashForm(parent, 256);
        this.viewer = new TableViewer((Composite)sashForm, 268501762);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.addColumn(Messages.Column_Date, 100, true);
        this.addColumn(Messages.Column_Time, 100, true);
        this.addColumn(Messages.Column_Type, 80, true);
        this.addColumn(Messages.Column_Session, 80, true);
        this.addColumn(Messages.Column_Message, 400, false);
        this.viewer.getTable().addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Table table = (Table)event.widget;
                int columnCount = table.getColumnCount();
                int w = table.getClientArea().width;
                int i = 0;
                while (i < columnCount - 1) {
                    w -= table.getColumn(i).getWidth();
                    ++i;
                }
                if (w > 0) {
                    table.getColumn(columnCount - 1).setWidth(w);
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object first;
                if (event.getSelection() instanceof IStructuredSelection && (first = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof ScriptDebugLogItem) {
                    ScriptDebugLogView.this.textDocument.set(((ScriptDebugLogItem)first).getMessage());
                    return;
                }
                ScriptDebugLogView.this.textDocument.set("");
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ScriptDebugLogContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ScriptDebugLogLabelProvider());
        this.viewer.setInput((Object)this.items);
        this.textDocument = new Document();
        this.textViewer = new TextViewer((Composite)sashForm, 840);
        this.textViewer.setDocument(this.textDocument);
        this.fontRegistryChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ScriptDebugLogView.this.handlePropertyChangeEvent(event);
            }
        };
        JFaceResources.getFontRegistry().addListener(this.fontRegistryChangeListener);
        this.updateFont();
        sashForm.setWeights(new int[]{75, 25});
        this.createActions();
        this.createMenu();
        this.createToolbar();
        this.createContextMenu();
    }

    public void dispose() {
        if (this.fontRegistryChangeListener != null) {
            JFaceResources.getFontRegistry().removeListener(this.fontRegistryChangeListener);
            this.fontRegistryChangeListener = null;
        }
        super.dispose();
    }

    protected void handlePropertyChangeEvent(PropertyChangeEvent event) {
        String key = event.getProperty();
        if (key.equals(THEME_ID)) {
            this.updateFont();
        }
    }

    private void updateFont() {
        this.textViewer.getTextWidget().setFont(JFaceResources.getFont((String)THEME_ID));
    }

    private void addColumn(String caption, int width, boolean center) {
        TableColumn column = new TableColumn(this.viewer.getTable(), 16384);
        column.setText(caption);
        column.setWidth(width);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(ScriptDebugLogItem item) {
        List list = this.items;
        synchronized (list) {
            this.items.add(item);
        }
        final Table table = this.viewer.getTable();
        if (table.isDisposed()) {
            return;
        }
        Display display = table.getDisplay();
        if (display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            public void run() {
                ScriptDebugLogView.this.viewer.refresh(false, false);
                if (table.isDisposed() || table.getDisplay().isDisposed()) {
                    return;
                }
                int itemCount = table.getItemCount();
                if (itemCount > 0) {
                    table.showItem(table.getItem(itemCount - 1));
                }
            }
        });
    }

    public void createActions() {
        this.copyAction = new ScriptDebugLogCopyAction(this.viewer);
        this.clearAction = new Action(Messages.ScriptDebugLogView_clear){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                List list = ScriptDebugLogView.this.items;
                synchronized (list) {
                    ScriptDebugLogView.this.items.clear();
                }
                ScriptDebugLogView.this.viewer.refresh();
            }
        };
    }

    private void createMenu() {
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add(this.copyAction);
        manager.add(this.clearAction);
    }

    private void createToolbar() {
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        manager.add(this.copyAction);
        manager.add(this.clearAction);
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ScriptDebugLogView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add(this.copyAction);
        manager.add(this.clearAction);
        manager.add((IContributionItem)new Separator("additions"));
    }
}

