/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.coloring;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.internal.ui.coloring.AbstractColoringPreferenceRequestor;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.coloring.EnablementStyle;
import org.eclipse.dltk.ui.coloring.FontStyle;
import org.eclipse.dltk.ui.coloring.IColoringPreferenceKey;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;

public class DefaultPreferenceRequestor
extends AbstractColoringPreferenceRequestor {
    private final IPreferenceStore store;
    private final String natureId;
    private Set<String> processedKeys = new HashSet<String>();

    public DefaultPreferenceRequestor(IPreferenceStore store, String natureId) {
        this.store = store;
        this.natureId = natureId;
    }

    public void addPreference(IColoringPreferenceKey key, String name, RGB color, EnablementStyle enablementStyle, FontStyle ... fontStyles) {
        if (!this.processedKeys.add(key.getColorKey())) {
            DLTKUIPlugin.warn("Duplicate color preference " + key.getColorKey() + " in " + this.natureId);
            return;
        }
        PreferenceConverter.setDefault((IPreferenceStore)this.store, (String)key.getColorKey(), (RGB)color);
        EnumSet<FontStyle> fontStyleSet = EnumSet.noneOf(FontStyle.class);
        Collections.addAll(fontStyleSet, fontStyles);
        this.store.setDefault(key.getBoldKey(), fontStyleSet.contains((Object)FontStyle.BOLD));
        this.store.setDefault(key.getItalicKey(), fontStyleSet.contains((Object)FontStyle.ITALIC));
        this.store.setDefault(key.getUnderlineKey(), fontStyleSet.contains((Object)FontStyle.UNDERLINE));
        this.store.setDefault(key.getStrikethroughKey(), fontStyleSet.contains((Object)FontStyle.STRIKETHROUGH));
        if (key.getEnableKey() != null && enablementStyle != EnablementStyle.ALWAYS_ON) {
            this.store.setDefault(key.getEnableKey(), enablementStyle == EnablementStyle.ON);
        }
    }
}

