/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.internal.javascript.validation.ValidationMessages;
import org.eclipse.dltk.javascript.core.JavaScriptProblems;
import org.eclipse.dltk.javascript.parser.JSProblemReporter;
import org.eclipse.dltk.javascript.parser.jsdoc.JSDocTag;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinfo.IJSDocTypeChecker;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.ArrayType;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.MapType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.RecordType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;
import org.eclipse.dltk.javascript.typeinfo.model.TypeRef;
import org.eclipse.dltk.javascript.typeinfo.model.UnionType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;

public class JSDocValidatorFactory {

    private static class TagAndType {
        private final JSType type;
        private final JSDocTag tag;
        private final IValueCollection collection;

        public TagAndType(JSType type, JSDocTag tag, IValueCollection collection) {
            this.type = type;
            this.tag = tag;
            this.collection = collection;
        }
    }

    public static class TypeChecker
    implements IJSDocTypeChecker {
        private List<TagAndType> lst = new ArrayList<TagAndType>();
        private final TypeInferencer2 context;
        private final JSProblemReporter reporter;

        public TypeChecker(TypeInferencer2 context, JSProblemReporter reporter) {
            this.context = context;
            this.reporter = reporter;
        }

        public void checkType(JSType type, JSDocTag tag) {
            if (type == null) {
                return;
            }
            if ((type = this.context.resolveTypeRef(type)) instanceof UnionType) {
                EList<JSType> targets = ((UnionType)type).getTargets();
                for (JSType targetType : targets) {
                    this.checkType(targetType, tag);
                }
            } else if (type instanceof ArrayType) {
                this.checkType(((ArrayType)type).getItemType(), tag);
            } else if (type instanceof MapType) {
                this.checkType(((MapType)type).getKeyType(), tag);
                this.checkType(((MapType)type).getValueType(), tag);
            } else if (type.getKind() == TypeKind.UNKNOWN || type.getKind() == TypeKind.UNRESOLVED) {
                this.lst.add(new TagAndType(type, tag, this.context.currentCollection()));
            } else {
                this.checkDeprecatedType(type, tag);
            }
        }

        public void validate() {
            for (TagAndType tagAndType : this.lst) {
                this.checkType(tagAndType.tag, tagAndType.type, tagAndType.collection);
            }
        }

        protected void checkType(JSDocTag tag, JSType type, IValueCollection collection) {
            if (type != null) {
                Assert.isTrue(((type = this.context.resolveTypeRef(type)).getKind() != TypeKind.UNRESOLVED ? 1 : 0) != 0);
                if (type.getKind() == TypeKind.UNKNOWN) {
                    if (!(type instanceof TypeRef) || collection == null || !collection.getChild(type.getName()).exists()) {
                        String className = type.getName();
                        if (className.indexOf(46) != -1) {
                            StringTokenizer st = new StringTokenizer(className, ".");
                            IValueReference child = null;
                            while (st.hasMoreTokens()) {
                                String token = st.nextToken();
                                if (child == null) {
                                    child = collection.getChild(token);
                                } else {
                                    IValueCollection function;
                                    if (child.getKind() == ReferenceKind.FUNCTION && (function = (IValueCollection)child.getAttribute("FUNCTION_SCOPE")) != null) {
                                        child = function.getThis();
                                    }
                                    child = child.getChild(token);
                                }
                                if (child.exists()) continue;
                                child = null;
                                break;
                            }
                            if (child != null) {
                                return;
                            }
                        }
                        this.reportUnknownType(tag, TypeUtil.getName(type));
                    }
                } else if (type instanceof ArrayType) {
                    this.checkType(tag, ((ArrayType)type).getItemType(), collection);
                } else if (type instanceof RecordType) {
                    for (Member member : ((RecordType)type).getMembers()) {
                        this.checkType(tag, member.getType(), collection);
                    }
                } else if (type instanceof MapType) {
                    this.checkType(tag, ((MapType)type).getValueType(), collection);
                    this.checkType(tag, ((MapType)type).getKeyType(), collection);
                } else if (type instanceof UnionType) {
                    EList<JSType> targets = ((UnionType)type).getTargets();
                    for (JSType unionTarget : targets) {
                        this.checkType(tag, unionTarget, collection);
                    }
                } else {
                    this.checkDeprecatedType(type, tag);
                }
            } else {
                this.reportUnknownType(tag, TypeUtil.getName(type));
            }
        }

        private void checkDeprecatedType(JSType type, JSDocTag tag) {
            Type t = TypeUtil.extractType(type);
            if (t != null && t.isDeprecated()) {
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_TYPE, NLS.bind((String)ValidationMessages.DeprecatedType, (Object)TypeUtil.getName(type)), tag.getStart(), tag.getEnd());
            }
        }

        public void reportUnknownType(JSDocTag tag, String name) {
            this.reportUnknownType(JavaScriptProblems.UNKNOWN_TYPE, tag, name);
        }

        public void reportUnknownType(IProblemIdentifier identifier, JSDocTag tag, String name) {
            int index2;
            int end = tag.getEnd();
            int start = end - tag.getValue().length();
            int index = tag.getValue().indexOf(123);
            if (index != -1 && (index2 = tag.getValue().indexOf(125, index)) != -1) {
                start = start + index + 1;
                end = start + index2 - 1;
            }
            this.reporter.reportProblem(identifier, NLS.bind((String)ValidationMessages.UnknownType, (Object)name), start, end);
        }
    }
}

