/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.search.matching2.MatchingCollector;
import org.eclipse.dltk.internal.javascript.parser.structure.IStructureRequestor;
import org.eclipse.dltk.javascript.ast.Argument;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.internal.search.ArgumentDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.FieldDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.FieldReferenceNode;
import org.eclipse.dltk.javascript.internal.search.LocalVariableDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.LocalVariableReferenceNode;
import org.eclipse.dltk.javascript.internal.search.MatchingNode;
import org.eclipse.dltk.javascript.internal.search.MethodDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.MethodReferenceNode;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchingCollectorSourceElementRequestor
implements IStructureRequestor {
    private final MatchingCollector<MatchingNode> matchingCollector;
    private final List<MatchingNode> nodes = new ArrayList<MatchingNode>();

    public MatchingCollectorSourceElementRequestor(MatchingCollector<MatchingNode> matchingCollector) {
        this.matchingCollector = matchingCollector;
    }

    public void report() {
        for (MatchingNode node : this.nodes) {
            this.matchingCollector.report((Object)node);
        }
        this.nodes.clear();
    }

    @Override
    public void acceptLocalReference(Identifier node, IValueReference reference) {
        this.nodes.add(new LocalVariableReferenceNode(node, reference.getLocation()));
    }

    @Override
    public void acceptFieldReference(Identifier node, IValueReference reference) {
        this.nodes.add(new FieldReferenceNode(node, reference));
    }

    @Override
    public void acceptMethodReference(Identifier node, int argCount, IValueReference reference) {
        this.nodes.add(new MethodReferenceNode(node, reference));
    }

    @Override
    public void acceptArgumentDeclaration(Argument argument, ISourceModule sourceModule, JSType type) {
        this.nodes.add(new ArgumentDeclarationNode(argument, sourceModule, type));
    }

    @Override
    public void enterNamespace(String[] namespace) {
    }

    @Override
    public void exitNamespace() {
    }

    @Override
    public void enterType(IElementRequestor.TypeInfo typeInfo) {
    }

    @Override
    public void exitType(int sourceEnd) {
    }

    @Override
    public void enterMethod(IElementRequestor.MethodInfo methodInfo, Expression identifier, IModelBuilder.IMethod method) {
        if (identifier == null) {
            return;
        }
        this.nodes.add(new MethodDeclarationNode(identifier, method));
    }

    @Override
    public void enterField(IElementRequestor.FieldInfo fieldInfo, Expression identifier, JSType type) {
        this.nodes.add(new FieldDeclarationNode(identifier, type));
    }

    @Override
    public void updateField(IElementRequestor.FieldInfo fieldInfo, int flags) {
    }

    @Override
    public boolean enterFieldCheckDuplicates(IElementRequestor.FieldInfo fieldInfo, Expression identifier, JSType type) {
        this.enterField(fieldInfo, identifier, type);
        return true;
    }

    @Override
    public void enterLocal(Identifier identifier, ISourceModule module, JSType type) {
        this.nodes.add(new LocalVariableDeclarationNode(identifier, module, type));
    }

    @Override
    public void exitMethod(int sourceEnd) {
    }

    @Override
    public void exitField(int sourceEnd) {
    }

    @Override
    public void exitLocal(int sourceEnd) {
    }
}

