/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.dltk.core.IScriptLanguageProvider;
import org.eclipse.dltk.core.IScriptNatureProvider;
import org.osgi.framework.Bundle;

public abstract class ScriptUtils {
    public static final File storeToMetadata(Plugin plugin, String name, String path) throws IOException {
        Bundle bundle = plugin.getBundle();
        File file = plugin.getStateLocation().append(name).toFile();
        ScriptUtils.storeFile(file, FileLocator.resolve((URL)bundle.getEntry(path)));
        return file;
    }

    private static void storeFile(File dest, URL url) throws IOException {
        BufferedInputStream input = null;
        OutputStream output = null;
        try {
            input = new BufferedInputStream(url.openStream());
            output = new BufferedOutputStream(new FileOutputStream(dest));
            int ch = -1;
            while ((ch = ((InputStream)input).read()) != -1) {
                output.write(ch);
            }
        }
        finally {
            if (input != null) {
                ((InputStream)input).close();
            }
            if (output != null) {
                output.close();
            }
        }
    }

    public static boolean checkNature(String natureId, Object input, boolean defaultValue) {
        if (input instanceof IScriptNatureProvider) {
            return natureId.equals(((IScriptNatureProvider)input).getNatureId());
        }
        if (input instanceof IScriptLanguageProvider) {
            return natureId.equals(((IScriptLanguageProvider)input).getLanguageToolkit().getNatureId());
        }
        return defaultValue;
    }

    public static String getNatureId(Object input) {
        if (input instanceof IScriptNatureProvider) {
            return ((IScriptNatureProvider)input).getNatureId();
        }
        if (input instanceof IScriptLanguageProvider) {
            return ((IScriptLanguageProvider)input).getLanguageToolkit().getNatureId();
        }
        return null;
    }
}

