/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.evaluation.types;

import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.evaluation.types.IClassType;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class ClassInstanceType
implements IClassType {
    private TypeDeclaration fClass;
    private ModuleDeclaration fModule;

    public ClassInstanceType(ModuleDeclaration module, TypeDeclaration method) {
        this.fClass = method;
        this.fModule = module;
    }

    public TypeDeclaration getTypeDeclaration() {
        return this.fClass;
    }

    public String getTypeName() {
        if (this.fClass != null) {
            return "class:" + this.fClass.getName() + " instance";
        }
        return "class instance: !!unknown!!";
    }

    public boolean subtypeOf(IEvaluatedType type) {
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fClass == null ? 0 : this.fClass.hashCode());
        result = 31 * result + (this.fModule == null ? 0 : this.fModule.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassInstanceType other = (ClassInstanceType)obj;
        if (this.fClass == null ? other.fClass != null : !this.fClass.equals(other.fClass)) {
            return false;
        }
        return !(this.fModule == null ? other.fModule != null : !this.fModule.equals(other.fModule));
    }
}

