/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKContentTypeManager;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptProjectUtil;
import org.eclipse.dltk.core.builder.IBuildChange;
import org.eclipse.dltk.core.builder.IBuildState;
import org.eclipse.dltk.core.builder.IProjectChange;
import org.eclipse.dltk.core.builder.IScriptBuilder;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.builder.AbstractBuildState;
import org.eclipse.dltk.internal.core.builder.BuildChange;
import org.eclipse.dltk.internal.core.builder.BuildStateStub;
import org.eclipse.dltk.internal.core.builder.FullBuildChange;
import org.eclipse.dltk.internal.core.builder.IncrementalBuildChange;
import org.eclipse.dltk.internal.core.builder.IncrementalProjectChange;
import org.eclipse.dltk.internal.core.builder.Messages;
import org.eclipse.dltk.internal.core.builder.ScriptBuilderManager;
import org.eclipse.dltk.internal.core.builder.State;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptBuilder
extends IncrementalProjectBuilder {
    public static final boolean DEBUG = DLTKCore.DEBUG_SCRIPT_BUILDER;
    public static final boolean TRACE = DLTKCore.TRACE_SCRIPT_BUILDER;
    private static final int TRACE_BUILDER_MIN_ELAPSED_TIME = 10;
    public IProject currentProject = null;
    ScriptProject scriptProject = null;
    State lastState;
    private static final QualifiedName PROPERTY_BUILDER_VERSION = new QualifiedName("org.eclipse.dltk.core", "builderVersion");
    private static final String CURRENT_VERSION = "200810012003-2123";
    private static final int WORK_RESOURCES = 50;
    private static final int WORK_EXTERNAL = 100;
    private static final int WORK_SOURCES = 100;
    private static final int WORK_BUILD = 750;
    static final String NONAME = "";

    public static void buildStarting() {
    }

    public static void buildFinished() {
        if (TRACE) {
            System.out.println("build finished");
        }
    }

    private static void log(String message) {
        System.out.println(message);
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        this.currentProject = this.getProject();
        if (this.currentProject == null || !this.currentProject.isAccessible()) {
            return new IProject[0];
        }
        if (!DLTKLanguageManager.hasScriptNature(this.currentProject)) {
            return null;
        }
        long startTime = 0L;
        if (DEBUG || TRACE) {
            startTime = System.currentTimeMillis();
            ScriptBuilder.log("\nStarting build of " + this.currentProject.getName() + " @ " + new Date(startTime));
        }
        this.scriptProject = (ScriptProject)DLTKCore.create(this.currentProject);
        if (!ScriptProjectUtil.isBuilderEnabled(this.scriptProject)) {
            if (monitor != null) {
                monitor.done();
            }
            return null;
        }
        IEnvironment environment = EnvironmentManager.getEnvironment(this.scriptProject);
        if (environment == null || !environment.isConnected()) {
            if (monitor != null) {
                monitor.done();
            }
            return null;
        }
        String version = this.currentProject.getPersistentProperty(PROPERTY_BUILDER_VERSION);
        if (version == null) {
            this.removeWrongTaskMarkers();
            this.currentProject.setPersistentProperty(PROPERTY_BUILDER_VERSION, CURRENT_VERSION);
            kind = 6;
        } else if (!CURRENT_VERSION.equals(version)) {
            if ("200810012003".equals(version)) {
                this.removeWrongTaskMarkers();
            }
            this.currentProject.setPersistentProperty(PROPERTY_BUILDER_VERSION, CURRENT_VERSION);
            kind = 6;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IProject[] requiredProjects = this.getRequiredProjects(true);
        try {
            if (kind == 6) {
                if (DEBUG) {
                    ScriptBuilder.log("Performing full build as requested by user");
                }
                this.fullBuild(monitor);
            } else {
                this.lastState = this.getLastState(this.currentProject, monitor);
                if (this.lastState == null) {
                    if (DEBUG) {
                        ScriptBuilder.log("Performing full build since last saved state was not found");
                    }
                    this.fullBuild(monitor);
                } else {
                    IResourceDelta delta = this.getDelta(this.getProject());
                    if (delta == null) {
                        if (DEBUG) {
                            ScriptBuilder.log("Performing full build since deltas are missing after incremental request");
                        }
                        this.fullBuild(monitor);
                    } else if (ScriptBuilder.isProjectConfigChange(delta)) {
                        if (DEBUG) {
                            ScriptBuilder.log("Performing full build since .project/.buildpath change");
                        }
                        this.fullBuild(monitor);
                    } else {
                        if (DEBUG) {
                            ScriptBuilder.log("Performing incremental build");
                        }
                        this.incrementalBuild(delta, requiredProjects, monitor);
                    }
                }
            }
        }
        catch (OperationCanceledException operationCanceledException) {}
        long endTime = 0L;
        if (DEBUG || TRACE) {
            endTime = System.currentTimeMillis();
        }
        if (DEBUG) {
            ScriptBuilder.log("Finished build of " + this.currentProject.getName() + " @ " + new Date(endTime) + ", elapsed " + (endTime - startTime) + " ms");
        }
        if (TRACE) {
            System.out.println("-----SCRIPT-BUILDER-INFORMATION-TRACE----------------------------");
            System.out.println("Finished build of project:" + this.currentProject.getName() + "\n" + "Building time:" + Long.toString(endTime - startTime) + "\n" + "Build type:" + (kind == 6 ? "Full build" : "Incremental build"));
            System.out.println("-----------------------------------------------------------------");
        }
        monitor.done();
        return requiredProjects;
    }

    private static boolean isProjectConfigChange(IResourceDelta projectDelta) {
        String[] filenames;
        String[] stringArray = filenames = new String[]{".buildpath", ".project"};
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            IResourceDelta delta = projectDelta.findMember((IPath)new Path(filename));
            if (delta != null) {
                switch (delta.getKind()) {
                    case 1: 
                    case 2: {
                        return true;
                    }
                    case 4: {
                        return (delta.getFlags() & 0x100100) != 0;
                    }
                }
            }
            ++n2;
        }
        return false;
    }

    private void removeWrongTaskMarkers() throws CoreException {
        IMarker[] markers = this.currentProject.findMarkers("org.eclipse.core.resources.taskmarker", false, 2);
        int i = 0;
        while (i < markers.length) {
            Map attributes;
            IMarker marker = markers[i];
            IResource resource = marker.getResource();
            if (resource.getType() == 1 && DLTKContentTypeManager.isValidResourceForContentType(this.scriptProject.getLanguageToolkit(), resource) && (attributes = marker.getAttributes()) != null && Boolean.FALSE.equals(attributes.get("userEditable")) && attributes.containsKey("lineNumber") && attributes.containsKey("message") && attributes.containsKey("priority") && attributes.containsKey("charStart") && attributes.containsKey("charEnd")) {
                marker.delete();
            }
            ++i;
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        long start;
        block9: {
            start = 0L;
            if (TRACE) {
                start = System.currentTimeMillis();
            }
            this.currentProject = this.getProject();
            if (!DLTKLanguageManager.hasScriptNature(this.currentProject)) {
                return;
            }
            this.scriptProject = (ScriptProject)DLTKCore.create(this.currentProject);
            if (this.currentProject == null || !this.currentProject.isAccessible()) {
                return;
            }
            try {
                monitor.beginTask(NLS.bind((String)Messages.ScriptBuilder_cleaningScriptsIn, (Object)this.currentProject.getName()), 66);
                if (monitor.isCanceled()) {
                    return;
                }
                ModelManager.getModelManager().setLastBuiltState(this.currentProject, null);
                IScriptBuilder[] builders = this.getScriptBuilders();
                if (builders != null) {
                    int k = 0;
                    while (k < builders.length) {
                        SubProgressMonitor sub = new SubProgressMonitor(monitor, 1);
                        builders[k].clean(this.scriptProject, (IProgressMonitor)sub);
                        if (monitor.isCanceled()) break;
                        ++k;
                    }
                }
                this.resetBuilders(builders, new BuildStateStub(this.currentProject.getName()), monitor);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block9;
                e.printStackTrace();
            }
        }
        if (TRACE) {
            System.out.println("-----SCRIPT-BUILDER-INFORMATION-TRACE----------------------------");
            System.out.println("Finished clean of project:" + this.currentProject.getName() + "\n" + "Building time:" + Long.toString(System.currentTimeMillis() - start));
            System.out.println("-----------------------------------------------------------------");
        }
        monitor.done();
    }

    private IProject[] getRequiredProjects(boolean includeBinaryPrerequisites) {
        if (this.scriptProject == null) {
            return new IProject[0];
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<IProject> projects = new ArrayList<IProject>();
        try {
            IBuildpathEntry[] entries = this.scriptProject.getExpandedBuildpath(true);
            int i = 0;
            int l = entries.length;
            while (i < l) {
                IBuildpathEntry entry = entries[i];
                IPath path = entry.getPath();
                IProject p = null;
                switch (entry.getEntryKind()) {
                    case 2: {
                        p = workspaceRoot.getProject(path.lastSegment());
                        if (!((BuildpathEntry)entry).isOptional() || ScriptProject.hasScriptNature(p)) break;
                        p = null;
                        break;
                    }
                    case 1: {
                        IResource resource;
                        if (!includeBinaryPrerequisites || path.segmentCount() <= 1 || !((resource = workspaceRoot.findMember(path.segment(0))) instanceof IProject)) break;
                        p = (IProject)resource;
                    }
                }
                if (p != null && !projects.contains(p)) {
                    projects.add(p);
                }
                ++i;
            }
        }
        catch (ModelException modelException) {
            return new IProject[0];
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    public State getLastState(IProject project, IProgressMonitor monitor) {
        return (State)ModelManager.getModelManager().getLastBuiltState(project, monitor);
    }

    private State clearLastState() {
        State state = new State(this);
        State prevState = (State)ModelManager.getModelManager().getLastBuiltState(this.currentProject, null);
        if (prevState != null && prevState.noCleanExternalFolders) {
            state.externalFolderLocations = prevState.externalFolderLocations;
            return state;
        }
        ModelManager.getModelManager().setLastBuiltState(this.currentProject, null);
        return state;
    }

    protected void fullBuild(IProgressMonitor monitor) {
        this.lastState = this.clearLastState();
        BuildState buildState = new BuildState(this.currentProject.getName());
        IScriptBuilder[] builders = null;
        try {
            monitor.setTaskName(NLS.bind((String)Messages.ScriptBuilder_buildingScriptsIn, (Object)this.currentProject.getName()));
            monitor.beginTask(NONAME, 1000);
            builders = this.getScriptBuilders();
            if (builders == null || builders.length == 0) {
                return;
            }
            try {
                IScriptBuilder builder;
                FullBuildChange buildChange = new FullBuildChange(this.currentProject, monitor);
                IScriptBuilder[] iScriptBuilderArray = builders;
                int n = builders.length;
                int n2 = 0;
                while (n2 < n) {
                    builder = iScriptBuilderArray[n2];
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    builder.prepare(buildChange, buildState, monitor);
                    ++n2;
                }
                iScriptBuilderArray = builders;
                n = builders.length;
                n2 = 0;
                while (n2 < n) {
                    long elapsed;
                    builder = iScriptBuilderArray[n2];
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    long start = TRACE ? System.currentTimeMillis() : 0L;
                    builder.build(buildChange, buildState, monitor);
                    if (TRACE && (elapsed = System.currentTimeMillis() - start) > 10L) {
                        System.out.println(String.valueOf(builder.getClass().getName()) + " " + elapsed + "ms");
                    }
                    ++n2;
                }
                this.updateExternalFolderLocations(buildChange);
            }
            catch (CoreException e) {
                DLTKCore.error(e);
            }
        }
        finally {
            this.resetBuilders(builders, buildState, monitor);
            ModelManager.getModelManager().setLastBuiltState(this.currentProject, this.lastState);
            monitor.done();
        }
    }

    protected void resetBuilders(IScriptBuilder[] builders, IBuildState state, IProgressMonitor monitor) {
        if (builders != null) {
            int k = 0;
            while (k < builders.length) {
                builders[k].endBuild(this.scriptProject, state, monitor);
                ++k;
            }
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProject[] requiredProjects, IProgressMonitor monitor) throws CoreException {
        HashSet<IPath> externalFoldersBefore;
        State newState = new State(this);
        if (this.lastState != null) {
            newState.copyFrom(this.lastState);
            externalFoldersBefore = new HashSet<IPath>(newState.getExternalFolders());
        } else {
            externalFoldersBefore = new HashSet();
        }
        this.lastState = newState;
        BuildState buildState = new BuildState(this.currentProject.getName());
        IScriptBuilder[] builders = null;
        try {
            monitor.setTaskName(NLS.bind((String)Messages.ScriptBuilder_buildingScriptsIn, (Object)this.currentProject.getName()));
            monitor.beginTask(NONAME, 1000);
            builders = this.getScriptBuilders();
            if (builders == null || builders.length == 0) {
                return;
            }
            try {
                int n;
                IBuildChange buildChange = this.createBuildChange(delta, requiredProjects, externalFoldersBefore, monitor);
                IScriptBuilder[] iScriptBuilderArray = builders;
                int n2 = builders.length;
                int n3 = 0;
                while (n3 < n2) {
                    IScriptBuilder builder = iScriptBuilderArray[n3];
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    builder.prepare(buildChange, buildState, monitor);
                    if (buildChange.getBuildType() == 1 && buildChange instanceof IncrementalBuildChange) {
                        buildChange = new FullBuildChange(this.currentProject, monitor);
                        this.lastState.resetDependencies();
                    }
                    ++n3;
                }
                HashSet<IPath> processed = new HashSet<IPath>();
                HashSet<IPath> queue = new HashSet<IPath>();
                if (buildChange instanceof IncrementalBuildChange) {
                    Set<IPath> changes = ((IncrementalBuildChange)buildChange).getChangedPaths();
                    if (TRACE) {
                        System.out.println("  Changes: " + changes);
                    }
                    queue.addAll(this.lastState.dependenciesOf(changes, true));
                    IProjectChange[] iProjectChangeArray = buildChange.getRequiredProjectChanges();
                    int n4 = iProjectChangeArray.length;
                    n = 0;
                    while (n < n4) {
                        IProjectChange projectChange = iProjectChangeArray[n];
                        Collection<IPath> projectChanges = ((IncrementalProjectChange)projectChange).getChangedPaths();
                        State projectState = this.getLastState(projectChange.getProject(), monitor);
                        if (projectState != null) {
                            projectChanges = projectState.allDependenciesOf(projectChanges);
                        }
                        queue.addAll(this.lastState.dependenciesOf(projectChanges, false));
                        ++n;
                    }
                    this.lastState.removeDependenciesFor(changes);
                    processed.addAll(changes);
                    queue.removeAll(processed);
                }
                IScriptBuilder[] iScriptBuilderArray2 = builders;
                n = builders.length;
                int projectChange = 0;
                while (projectChange < n) {
                    long elapsed;
                    IScriptBuilder builder = iScriptBuilderArray2[projectChange];
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    long start = TRACE ? System.currentTimeMillis() : 0L;
                    builder.build(buildChange, buildState, monitor);
                    if (TRACE && (elapsed = System.currentTimeMillis() - start) > 10L) {
                        System.out.println(String.valueOf(builder.getClass().getName()) + " " + elapsed + "ms");
                    }
                    ++projectChange;
                }
                while (!buildState.getStructuralChanges().isEmpty() && !queue.isEmpty()) {
                    if (TRACE) {
                        System.out.println("  Queue: " + queue);
                    }
                    HashSet<IPath> nextQueue = new HashSet<IPath>();
                    nextQueue.addAll(this.lastState.dependenciesOf(queue, false));
                    this.lastState.removeDependenciesFor(queue);
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    ArrayList<IFile> files = new ArrayList<IFile>();
                    for (IPath path : queue) {
                        files.add(root.getFile(path));
                    }
                    buildState.resetStructuralChanges();
                    DependencyBuildChange qChange = new DependencyBuildChange(this.currentProject, delta, files, monitor);
                    IScriptBuilder[] iScriptBuilderArray3 = builders;
                    int n5 = builders.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        long elapsed;
                        IScriptBuilder builder = iScriptBuilderArray3[n6];
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        long start = TRACE ? System.currentTimeMillis() : 0L;
                        builder.build(qChange, buildState, monitor);
                        if (TRACE && (elapsed = System.currentTimeMillis() - start) > 10L) {
                            System.out.println(String.valueOf(builder.getClass().getName()) + " " + elapsed + "ms");
                        }
                        ++n6;
                    }
                    processed.addAll(queue);
                    nextQueue.removeAll(processed);
                    queue.clear();
                    queue.addAll(nextQueue);
                }
                this.updateExternalFolderLocations(buildChange);
            }
            catch (CoreException e) {
                DLTKCore.error(e);
            }
        }
        finally {
            this.resetBuilders(builders, buildState, monitor);
            ModelManager.getModelManager().setLastBuiltState(this.currentProject, this.lastState);
            monitor.done();
        }
    }

    private IBuildChange createBuildChange(IResourceDelta delta, IProject[] requiredProjects, Set<IPath> externalFoldersBefore, IProgressMonitor monitor) {
        ArrayList<IncrementalProjectChange> projectChanges = new ArrayList<IncrementalProjectChange>();
        IProject[] iProjectArray = requiredProjects;
        int n = requiredProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IResourceDelta projectDelta = this.getDelta(project);
            if (projectDelta == null) {
                return new FullBuildChange(this.currentProject, monitor);
            }
            if (projectDelta.getKind() != 0) {
                projectChanges.add(new IncrementalProjectChange(projectDelta, project, monitor));
            }
            ++n2;
        }
        return new IncrementalBuildChange(delta, projectChanges.toArray(new IProjectChange[projectChanges.size()]), this.currentProject, monitor, new ArrayList<IPath>(externalFoldersBefore));
    }

    private void updateExternalFolderLocations(IBuildChange buildChange) throws CoreException {
        this.lastState.externalFolderLocations.clear();
        this.lastState.externalFolderLocations.addAll(buildChange.getExternalPaths(0));
    }

    protected IScriptBuilder[] getScriptBuilders() throws CoreException {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(this.scriptProject);
        if (toolkit != null) {
            IScriptBuilder[] builders = ScriptBuilderManager.getScriptBuilders(toolkit.getNatureId());
            if (builders != null) {
                ArrayList<IScriptBuilder> result = new ArrayList<IScriptBuilder>(builders.length);
                int k = 0;
                while (k < builders.length) {
                    if (builders[k].initialize(this.scriptProject)) {
                        result.add(builders[k]);
                    }
                    ++k;
                }
                builders = result.toArray(new IScriptBuilder[result.size()]);
            }
            return builders;
        }
        return null;
    }

    public static void removeProblemsAndTasksFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.eclipse.dltk.core.problem", false, 2);
                resource.deleteMarkers("org.eclipse.dltk.core.task", false, 2);
            }
        }
        catch (CoreException coreException) {}
    }

    public static void writeState(Object state, DataOutputStream out) throws IOException {
        ((State)state).write(out);
    }

    public static State readState(IProject project, DataInputStream in) throws IOException {
        State state = State.read(project, in);
        return state;
    }

    private class BuildState
    extends AbstractBuildState {
        public BuildState(String projectName) {
            super(projectName);
        }

        public void recordImportProblem(IPath path) {
            ScriptBuilder.this.lastState.recordImportProblem(path);
        }

        public void recordDependency(IPath path, IPath dependency) {
            ScriptBuilder.this.lastState.recordDependency(path, dependency);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DependencyBuildChange
    extends BuildChange {
        public DependencyBuildChange(IProject project, IResourceDelta delta, List<IFile> files, IProgressMonitor monitor) {
            super(project, delta, files, monitor);
        }

        @Override
        public boolean isDependencyBuild() {
            return true;
        }
    }
}

