/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ti.goals;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.search.FieldReferenceMatch;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.MethodReferenceMatch;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.goals.ItemReference;
import org.eclipse.dltk.ti.goals.PossiblePosition;

public abstract class SearchBasedGoalEvaluator
extends GoalEvaluator {
    private List<IGoal> possiblePositionsGoals = new ArrayList<IGoal>();
    private List<ItemReference> references = new ArrayList<ItemReference>();
    private SearchRequestor requestor = new SearchRequestor(){

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            SearchMatch match2;
            ASTNode node = null;
            if (match instanceof FieldReferenceMatch) {
                match2 = (FieldReferenceMatch)match;
                node = ((FieldReferenceMatch)match2).getNode();
            } else if (match instanceof MethodReferenceMatch) {
                match2 = (MethodReferenceMatch)match;
                node = ((MethodReferenceMatch)match2).getNode();
            }
            PossiblePosition pos = new PossiblePosition(match.getResource(), match.getOffset(), match.getLength(), node);
            SearchBasedGoalEvaluator.this.possiblePositionsGoals.add(SearchBasedGoalEvaluator.this.createVerificationGoal(pos));
        }
    };

    public SearchBasedGoalEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        IGoal goal = this.getGoal();
        IScriptProject project = null;
        IContext context = goal.getContext();
        if (context instanceof ISourceModuleContext) {
            ISourceModuleContext basicContext = (ISourceModuleContext)((Object)goal.getContext());
            project = basicContext.getSourceModule().getScriptProject();
        }
        if (project == null) {
            return null;
        }
        IDLTKSearchScope scope = SearchEngine.createSearchScope(project);
        SearchPattern pattern = this.createSearchPattern(scope.getLanguageToolkit());
        SearchEngine engine = new SearchEngine();
        try {
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, this.requestor, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return IGoal.NO_GOALS;
        }
        return this.possiblePositionsGoals.toArray(new IGoal[this.possiblePositionsGoals.size()]);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (result != null && result instanceof ItemReference) {
            this.references.add((ItemReference)result);
        }
        return IGoal.NO_GOALS;
    }

    public Object produceResult() {
        return this.references.toArray(new ItemReference[this.references.size()]);
    }

    protected abstract SearchPattern createSearchPattern(IDLTKLanguageToolkit var1);

    protected abstract IGoal createVerificationGoal(PossiblePosition var1);
}

