/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.manipulation.RefactoringChecks;
import org.eclipse.dltk.core.manipulation.SourceModuleChange;
import org.eclipse.dltk.internal.corext.refactoring.ScriptRefactoringDescriptor;
import org.eclipse.dltk.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.dltk.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.dltk.internal.javascript.core.manipulation.JavascriptManipulationPlugin;
import org.eclipse.dltk.internal.javascript.core.manipulation.Messages;
import org.eclipse.dltk.internal.javascript.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.CallInliner;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.SourceProvider;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.TargetProvider;
import org.eclipse.dltk.javascript.core.dom.CallExpression;
import org.eclipse.dltk.javascript.core.dom.FunctionExpression;
import org.eclipse.dltk.javascript.core.dom.Node;
import org.eclipse.dltk.javascript.core.dom.Source;
import org.eclipse.dltk.javascript.core.dom.rewrite.ASTConverter;
import org.eclipse.dltk.javascript.core.dom.rewrite.NodeFinder;
import org.eclipse.dltk.javascript.core.dom.rewrite.RefactoringUtils;
import org.eclipse.dltk.javascript.core.dom.rewrite.RewriteAnalyzer;
import org.eclipse.dltk.javascript.core.refactoring.descriptors.InlineMethodDescriptor;
import org.eclipse.dltk.javascript.parser.JavaScriptParserUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InlineMethodRefactoring
extends Refactoring {
    private static final String ATTRIBUTE_MODE = "mode";
    private static final String ATTRIBUTE_DELETE = "delete";
    private ISourceModule cu;
    private int offset;
    private int length;
    private IMethod method;
    private Mode initialMode;
    private Mode currentMode;
    private boolean deleteSource;
    private Source declRoot;
    private Node declNode;
    private SourceProvider sourceProvider;
    private TargetProvider targetProvider;
    private TextChangeManager changeManager;

    public InlineMethodRefactoring(ISourceModule cu, int offset, int length) {
        this.cu = cu;
        this.offset = offset;
        this.length = length;
        this.deleteSource = false;
    }

    public String getName() {
        return RefactoringCoreMessages.InlineMethodRefactoring_name;
    }

    public IMethod getMethod() {
        return this.method;
    }

    public boolean canEnableDeleteSource() {
        return !this.method.isReadOnly();
    }

    public void setDeleteSource(boolean remove) {
        if (remove) {
            Assert.isTrue((boolean)this.canEnableDeleteSource());
        }
        this.deleteSource = remove;
    }

    public Mode getInitialMode() {
        return this.initialMode;
    }

    public RefactoringStatus setCurrentMode(Mode mode) {
        if (this.currentMode == mode) {
            return new RefactoringStatus();
        }
        Assert.isTrue((this.getInitialMode() == Mode.SINGLE ? 1 : 0) != 0);
        this.currentMode = mode;
        return new RefactoringStatus();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) {
        RefactoringStatus result = new RefactoringStatus();
        if (this.method == null) {
            try {
                IModelElement[] elements = this.cu.codeSelect(this.offset, this.length);
                if (elements.length != 1 || !(elements[0] instanceof IMethod)) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineMethodRefactoring_error_noMethodDeclaration);
                }
                this.method = (IMethod)elements[0];
                int start = this.method.getNameRange().getOffset();
                this.initialMode = start <= this.offset && this.offset <= start + this.method.getNameRange().getLength() && this.method.getSourceModule() == this.cu ? Mode.ALL : Mode.SINGLE;
                this.currentMode = this.initialMode;
                this.declRoot = (Source)ASTConverter.convert((ASTNode)JavaScriptParserUtil.parse((ISourceModule)this.method.getSourceModule()));
                this.declNode = NodeFinder.findNode(this.declRoot, this.method.getNameRange());
                FunctionExpression expr = RefactoringUtils.getFunctionDeclaration(this.declNode);
                if (expr == null) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineMethodRefactoring_error_noMethodDeclaration);
                }
                this.sourceProvider = new SourceProvider(expr, this.method);
                if (result.hasFatalError()) {
                    return result;
                }
            }
            catch (ModelException e) {
                JavascriptManipulationPlugin.log(e);
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineMethodRefactoring_error_noMethodDeclaration);
            }
        }
        result.merge(this.sourceProvider.checkActivation());
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 20);
        this.changeManager = new TextChangeManager();
        RefactoringStatus result = new RefactoringStatus();
        this.sourceProvider.initialize();
        if (this.currentMode == Mode.ALL) {
            this.targetProvider = TargetProvider.create(this.method);
        } else {
            this.targetProvider = TargetProvider.create(this.cu, this.offset, this.length);
            this.deleteSource = false;
        }
        pm.setTaskName(RefactoringCoreMessages.InlineMethodRefactoring_searching);
        RefactoringStatus searchStatus = new RefactoringStatus();
        List<ISourceModule> units = this.targetProvider.getAffectedSourceModules(searchStatus, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        if (searchStatus.hasFatalError()) {
            result.merge(searchStatus);
            return result;
        }
        IFile[] filesToBeModified = this.getFilesToBeModified(units);
        result.merge(RefactoringChecks.validateModifiesFiles((IFile[])filesToBeModified, (Object)this.getValidationContext()));
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(ResourceChangeChecker.checkFilesToBeChanged((IFile[])filesToBeModified, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        SubProgressMonitor sub = new SubProgressMonitor(pm, 15);
        sub.beginTask("", (units.size() + 1) * 3);
        boolean occursInDeclUnit = false;
        for (ISourceModule unit : units) {
            if (!unit.equals(this.method.getSourceModule())) {
                this.processUnit(unit, (IProgressMonitor)sub, result);
                continue;
            }
            occursInDeclUnit = true;
        }
        if (occursInDeclUnit) {
            sub.worked(3);
        }
        if (this.deleteSource || occursInDeclUnit) {
            this.processUnit(this.method.getSourceModule(), (IProgressMonitor)sub, result);
        }
        result.merge(searchStatus);
        sub.done();
        pm.done();
        return result;
    }

    private void processUnit(ISourceModule unit, IProgressMonitor pm, RefactoringStatus result) throws CoreException {
        pm.subTask(Messages.format(RefactoringCoreMessages.InlineMethodRefactoring_processing, BasicElementLabels.getResourceName((IResource)unit.getCorrespondingResource())));
        CallInliner inliner = null;
        boolean modified = false;
        Source root = this.targetProvider.getRoot(unit);
        ChangeRecorder cr = new ChangeRecorder((EObject)this.targetProvider.getRoot(unit));
        Node[] bodies = this.targetProvider.getAffectedBodyDeclarations(unit, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        if (bodies.length == 0) {
            return;
        }
        inliner = new CallInliner(unit, this.sourceProvider);
        Node[] nodeArray = bodies;
        int n = bodies.length;
        int n2 = 0;
        while (n2 < n) {
            CallExpression[] invocations;
            Node body = nodeArray[n2];
            inliner.initialize(body);
            RefactoringStatus nestedInvocations = new RefactoringStatus();
            CallExpression[] callExpressionArray = invocations = this.removeNestedCalls(nestedInvocations, unit, this.targetProvider.getInvocations(body, (IProgressMonitor)new SubProgressMonitor(pm, 2)));
            int n3 = invocations.length;
            int n4 = 0;
            while (n4 < n3) {
                CallExpression invocation = callExpressionArray[n4];
                RefactoringStatus checkInline = inliner.initialize(invocation, this.targetProvider.getStatusSeverity());
                result.merge(checkInline);
                if (result.hasFatalError()) break;
                if (checkInline.getSeverity() >= this.targetProvider.getStatusSeverity()) {
                    this.deleteSource = false;
                } else {
                    modified = true;
                    inliner.perform();
                }
                ++n4;
            }
            if (!nestedInvocations.isOK()) {
                result.merge(nestedInvocations);
                this.deleteSource = false;
            }
            ++n2;
        }
        if (this.deleteSource && unit.equals(this.method.getSourceModule())) {
            modified = true;
            Node node = this.sourceProvider.getDeclaration();
            node = NodeFinder.findNode(root, node.getBegin(), node.getEnd());
            while (!node.eContainmentFeature().isMany()) {
                node = (Node)node.eContainer();
            }
            List list = (List)node.eContainer().eGet((EStructuralFeature)node.eContainmentFeature());
            list.remove(node);
        }
        if (modified) {
            ChangeDescription cd = cr.endRecording();
            RewriteAnalyzer rewrite = new RewriteAnalyzer(cd, unit.getSource());
            rewrite.rewrite(root);
            cd.apply();
            SourceModuleChange change = new SourceModuleChange(unit.getElementName(), unit);
            change.setEdit(rewrite.getEdit());
            this.changeManager.manage(unit, (TextChange)change);
        } else {
            cr.endRecording();
        }
        pm.worked(1);
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IScriptProject scriptProject = this.cu.getScriptProject();
        if (scriptProject != null) {
            project = scriptProject.getElementName();
        }
        int flags = 589826;
        String description = Messages.format(RefactoringCoreMessages.InlineMethodRefactoring_descriptor_description_short, this.method.getElementName());
        Messages.format(RefactoringCoreMessages.InlineMethodRefactoring_descriptor_description, new String[]{this.method.getElementName(), this.cu.getElementName()});
        InlineMethodDescriptor descriptor = new InlineMethodDescriptor(project, description, "", arguments, flags);
        arguments.put("input", ScriptRefactoringDescriptor.elementToHandle((String)project, (IModelElement)this.cu));
        arguments.put("selection", String.valueOf(new Integer(this.offset).toString()) + " " + new Integer(this.length).toString());
        arguments.put(ATTRIBUTE_DELETE, Boolean.valueOf(this.deleteSource).toString());
        arguments.put(ATTRIBUTE_MODE, new Integer(this.currentMode == Mode.ALL ? 1 : 0).toString());
        return new DynamicValidationRefactoringChange((RefactoringDescriptor)descriptor, RefactoringCoreMessages.InlineMethodRefactoring_edit_inlineCall, (Change[])this.changeManager.getAllChanges());
    }

    private IFile[] getFilesToBeModified(List<ISourceModule> units) {
        IFile file;
        ArrayList<IFile> result = new ArrayList<IFile>(units.size() + 1);
        for (ISourceModule unit : units) {
            IFile file2 = this.getFile(unit);
            if (file2 == null) continue;
            result.add(file2);
        }
        if (this.deleteSource && (file = this.getFile(this.method.getSourceModule())) != null && !units.contains(file)) {
            result.add(file);
        }
        return result.toArray(new IFile[result.size()]);
    }

    private IFile getFile(ISourceModule unit) {
        IResource resource = (unit = unit.getPrimary()).getResource();
        if (resource != null && resource.getType() == 1) {
            return (IFile)resource;
        }
        return null;
    }

    private CallExpression[] removeNestedCalls(RefactoringStatus status, ISourceModule unit, CallExpression[] invocations) {
        ArrayList<CallExpression> result = new ArrayList<CallExpression>();
        CallExpression[] callExpressionArray = invocations;
        int n = invocations.length;
        int n2 = 0;
        while (n2 < n) {
            CallExpression invocation = callExpressionArray[n2];
            boolean ok = true;
            CallExpression[] callExpressionArray2 = invocations;
            int n3 = invocations.length;
            int n4 = 0;
            while (n4 < n3) {
                Node parent = callExpressionArray2[n4];
                parent = (Node)parent.eContainer();
                while (parent != null && parent != invocation) {
                    parent = (Node)parent.eContainer();
                }
                if (parent != null) {
                    ok = false;
                }
                ++n4;
            }
            if (ok) {
                result.add(invocation);
            } else {
                status.addError(RefactoringCoreMessages.InlineMethodRefactoring_nestedInvocation);
            }
            ++n2;
        }
        return result.toArray(new CallExpression[result.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        ALL,
        SINGLE;

    }
}

