/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.parser;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.tcl.parser.ITclErrorReporter;
import org.eclipse.dltk.tcl.parser.TclError;

public class TclErrorCollector
implements ITclErrorReporter {
    private Set<TclError> errors = new HashSet<TclError>();

    public void report(int code, String message, String[] extraMessage, int start, int end, ProblemSeverity kind) {
        boolean insertNewError = true;
        TclError errorToReplace = null;
        for (TclError error : this.errors) {
            if (error.getStart() != start || error.getEnd() != end) continue;
            if (error.getCode() < code) {
                errorToReplace = error;
                break;
            }
            insertNewError = false;
            break;
        }
        if (errorToReplace != null) {
            this.errors.remove(errorToReplace);
        }
        if (insertNewError) {
            this.errors.add(new TclError(code, message, extraMessage, start, end, kind));
        }
    }

    public void report(TclError e) {
        boolean insertNewError = true;
        TclError errorToReplace = null;
        int start = e.getStart();
        int end = e.getEnd();
        int code = e.getCode();
        for (TclError error : this.errors) {
            if (error.getStart() != start || error.getEnd() != end) continue;
            if (error.getCode() < code) {
                errorToReplace = error;
                break;
            }
            insertNewError = false;
            break;
        }
        if (errorToReplace != null) {
            this.errors.remove(errorToReplace);
        }
        if (insertNewError) {
            this.errors.add(e);
        }
    }

    public void addAll(TclErrorCollector collector) {
        for (TclError e : collector.errors) {
            this.report(e);
        }
    }

    public void reportAll(ITclErrorReporter reporter) {
        if (reporter != null) {
            for (TclError error : this.errors) {
                reporter.report(error.getCode(), error.getMessage(), error.getExtraArguments(), error.getStart(), error.getEnd(), error.getErrorKind());
            }
        }
    }

    public void reportAll(final IProblemReporter reporter, final ISourceLineTracker tracker) {
        this.reportAll(new ITclErrorReporter(){

            public void report(int code, String message, String[] extraMessage, int start, int end, ProblemSeverity kind) {
                reporter.reportProblem((IProblem)new DefaultProblem(message, code, extraMessage, kind, start, end, tracker.getLineNumberOfOffset(start)));
            }
        });
    }

    public int getCount() {
        return this.errors.size();
    }

    public TclError[] getErrors() {
        return this.errors.toArray(new TclError[this.errors.size()]);
    }
}

