/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.internal.testing.wizards.WizardMessages;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class CheckedTableSelectionDialog
extends SelectionStatusDialog {
    private CheckboxTableViewer fViewer;
    private ILabelProvider fLabelProvider;
    private IStructuredContentProvider fContentProvider;
    private ISelectionStatusValidator fValidator = null;
    private String fEmptyListMessage = WizardMessages.CheckedTableSelectionDialog_emptyListMessage;
    private IStatus fCurrStatus = Status.OK_STATUS;
    private List fFilters;
    private Object fInput;
    private boolean fIsEmpty;
    private int fWidth = 40;
    private int fHeight = 18;

    public CheckedTableSelectionDialog(Shell parent, ILabelProvider labelProvider, IStructuredContentProvider contentProvider) {
        super(parent);
        this.fLabelProvider = labelProvider;
        this.fContentProvider = contentProvider;
        this.setResult(new ArrayList(0));
        this.setStatusLineAboveButtons(true);
    }

    public void setInitialSelection(Object selection) {
        this.setInitialSelections(new Object[]{selection});
    }

    public void setEmptyListMessage(String message) {
        this.fEmptyListMessage = message;
    }

    public void addFilter(ViewerFilter filter) {
        if (this.fFilters == null) {
            this.fFilters = new ArrayList(4);
        }
        this.fFilters.add(filter);
    }

    public void setValidator(ISelectionStatusValidator validator) {
        this.fValidator = validator;
    }

    public void setInput(Object input) {
        this.fInput = input;
    }

    public void setSize(int width, int height) {
        this.fWidth = width;
        this.fHeight = height;
    }

    protected void updateOKStatus() {
        if (!this.fIsEmpty) {
            if (this.fValidator != null) {
                this.fCurrStatus = this.fValidator.validate(this.fViewer.getCheckedElements());
                this.updateStatus(this.fCurrStatus);
            } else if (!this.fCurrStatus.isOK()) {
                this.fCurrStatus = Status.CANCEL_STATUS;
            }
        } else {
            this.fCurrStatus = new Status(4, "org.eclipse.dltk.testing", this.fEmptyListMessage, null);
        }
        this.updateStatus(this.fCurrStatus);
    }

    public int open() {
        this.fIsEmpty = this.evaluateIfTableEmpty(this.fInput);
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                CheckedTableSelectionDialog.this.access$superOpen();
            }
        });
        return this.getReturnCode();
    }

    private void access$superOpen() {
        super.open();
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected void computeResult() {
        this.setResult(Arrays.asList(this.fViewer.getCheckedElements()));
    }

    public void create() {
        super.create();
        List initialSelections = this.getInitialElementSelections();
        if (initialSelections.size() > 0) {
            this.fViewer.setCheckedElements(initialSelections.toArray());
        }
        this.updateOKStatus();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label messageLabel = this.createMessageArea(composite);
        Table treeWidget = this.createTableViewer(composite);
        Composite buttonComposite = this.createSelectionButtons(composite);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        data.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        treeWidget.setLayoutData((Object)data);
        if (this.fIsEmpty) {
            messageLabel.setEnabled(false);
            treeWidget.setEnabled(false);
            buttonComposite.setEnabled(false);
        }
        CheckedTableSelectionDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private Table createTableViewer(Composite parent) {
        this.fViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CheckedTableSelectionDialog.this.updateOKStatus();
            }
        });
        if (this.fFilters != null) {
            int i = 0;
            while (i != this.fFilters.size()) {
                this.fViewer.addFilter((ViewerFilter)this.fFilters.get(i));
                ++i;
            }
        }
        this.fViewer.setInput(this.fInput);
        return this.fViewer.getTable();
    }

    private Composite createSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        Button selectButton = this.createButton(buttonComposite, 18, WizardMessages.CheckedTableSelectionDialog_selectAll, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckedTableSelectionDialog.this.fViewer.setCheckedElements(CheckedTableSelectionDialog.this.fContentProvider.getElements(CheckedTableSelectionDialog.this.fInput));
                CheckedTableSelectionDialog.this.updateOKStatus();
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, 19, WizardMessages.CheckedTableSelectionDialog_deselectAll, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckedTableSelectionDialog.this.fViewer.setCheckedElements(new Object[0]);
                CheckedTableSelectionDialog.this.updateOKStatus();
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
        return buttonComposite;
    }

    private boolean evaluateIfTableEmpty(Object input) {
        Object[] elements = this.fContentProvider.getElements(input);
        if (elements.length > 0 && this.fFilters != null) {
            int i = 0;
            while (i < this.fFilters.size()) {
                ViewerFilter curr = (ViewerFilter)this.fFilters.get(i);
                elements = curr.filter((Viewer)this.fViewer, input, elements);
                ++i;
            }
        }
        return elements.length == 0;
    }
}

