/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.formatter.internal.nodes;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.formatter.IFormatterContext;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.formatter.IFormatterNode;
import org.eclipse.dltk.formatter.IFormatterWriter;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterBlockWithBeginEndNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.IParensConfiguration;

public class ParensNode
extends FormatterBlockWithBeginEndNode {
    private final IParensConfiguration configuration;
    private final boolean indenting;

    public ParensNode(IFormatterDocument document, IParensConfiguration configuration) {
        this(document, configuration, false);
    }

    public ParensNode(IFormatterDocument document, IParensConfiguration configuration, boolean indenting) {
        super(document);
        Assert.isNotNull((Object)configuration);
        this.configuration = configuration;
        this.indenting = indenting;
    }

    protected boolean isIndenting() {
        return this.indenting;
    }

    public void accept(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        this.writeSpace(context, visitor, this.configuration.getSpaceBeforeLeftParen());
        if (this.getBegin() != null) {
            IFormatterNode[] nodes = this.getBegin();
            int i = 0;
            while (i < nodes.length) {
                nodes[i].accept(context, visitor);
                ++i;
            }
        }
        this.writeSpace(context, visitor, this.configuration.getSpaceAfterLeftParen());
        boolean indenting = this.isIndenting();
        if (indenting) {
            context.incIndent();
        }
        this.acceptBody(context, visitor);
        if (indenting) {
            context.decIndent();
        }
        this.writeSpace(context, visitor, this.configuration.getSpaceBeforeRightParen());
        if (this.getEnd() != null) {
            visitor.write(context, this.getEnd().getStartOffset(), this.getEnd().getEndOffset());
        }
    }

    private void writeSpace(IFormatterContext context, IFormatterWriter visitor, boolean flag) throws Exception {
        visitor.writeText(context, flag ? " " : "");
    }
}

