/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IParameter;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.javascript.scriptdoc.IndentManipulation;
import org.eclipse.dltk.javascript.scriptdoc.ScriptdocContentAccess;

public class JSCodeGeneration {
    public static String getMethodComment(IMethod meth, IMethod overridden, String lineDelimiter) {
        String existingComment = null;
        try {
            ISourceRange range = ScriptdocContentAccess.getJavadocRange((IMember)meth);
            if (range != null) {
                ISourceModule compilationUnit = meth.getSourceModule();
                existingComment = compilationUnit.getBuffer().getText(range.getOffset(), range.getLength());
            }
        }
        catch (Exception exception) {}
        StringBuffer buf = new StringBuffer();
        if (existingComment != null && !JSCodeGeneration.isEmptyComment(existingComment)) {
            ArrayList<String> lines = new ArrayList<String>();
            ArrayList<String> paramLines = new ArrayList<String>();
            int paramStart = -1;
            StringTokenizer st = new StringTokenizer(existingComment, lineDelimiter);
            while (st.hasMoreTokens()) {
                int index;
                String line = st.nextToken().trim();
                if (line.startsWith("*")) {
                    line = String.valueOf(' ') + line;
                }
                if ((index = line.indexOf("@param")) != -1) {
                    if (paramStart == -1) {
                        paramStart = lines.size() - 1;
                    }
                    paramLines.add(line);
                    continue;
                }
                lines.add(line);
            }
            int parameterLength = 0;
            try {
                IParameter[] parameters = meth.getParameters();
                parameterLength = parameters.length;
                int paramCounter = 0;
                while (paramCounter < parameterLength) {
                    block22: {
                        IParameter parameter = parameters[paramCounter];
                        int i = 0;
                        while (i < paramLines.size()) {
                            String paramLine = (String)paramLines.get(i);
                            if (paramLine.indexOf(" " + parameter.getName()) != -1) {
                                if (i != paramCounter) {
                                    paramLines.remove(i);
                                    paramLines.add(paramCounter, paramLine);
                                }
                                break block22;
                            }
                            ++i;
                        }
                        paramLines.add(" * @param {Object} " + parameter.getName());
                    }
                    ++paramCounter;
                }
            }
            catch (ModelException modelException) {}
            if (paramStart == -1) {
                paramStart = lines.size() - 2;
            }
            int i = 0;
            while (i < lines.size()) {
                buf.append((String)lines.get(i)).append(lineDelimiter);
                if (paramStart == i) {
                    int j = 0;
                    while (j < parameterLength) {
                        buf.append((String)paramLines.get(j)).append(lineDelimiter);
                        ++j;
                    }
                }
                ++i;
            }
        } else {
            buf.append("/**").append(lineDelimiter);
            try {
                IParameter[] iParameterArray = meth.getParameters();
                int n = iParameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IParameter parameter = iParameterArray[n2];
                    buf.append(" * @param {Object} " + parameter.getName()).append(lineDelimiter);
                    ++n2;
                }
            }
            catch (ModelException modelException) {}
            buf.append(" * @return {Object}").append(lineDelimiter);
            buf.append(" */").append(lineDelimiter);
        }
        return buf.toString();
    }

    public static String getFieldComment(ISourceModule sourceModule, String typeName, String fieldName, String lineDelimiter) {
        StringBuffer buf = new StringBuffer();
        buf.append("/**").append(lineDelimiter);
        buf.append(" * " + fieldName).append(lineDelimiter);
        buf.append(" * @type ").append("{").append(typeName != null ? typeName : "Object").append("}").append(lineDelimiter);
        buf.append(" */").append(lineDelimiter);
        return buf.toString();
    }

    public static String getTypeComment(ISourceModule sourceModule, String typeQualifiedName, String[] typeParameterNames, String lineDelimiter) {
        return null;
    }

    public static String getIndentString(String line, IScriptProject project) {
        return IndentManipulation.extractIndentString(line, JSCodeGeneration.getTabWidth(project), JSCodeGeneration.getIndentWidth(project));
    }

    public static int getTabWidth(IScriptProject project) {
        PreferencesLookupDelegate prefs = new PreferencesLookupDelegate(project);
        String key = "space".equals(prefs.getString("org.eclipse.dltk.javascript.ui", "formatter.tabulation.char")) ? "formatter.indentation.size" : "formatter.tabulation.size";
        return prefs.getInt("org.eclipse.dltk.javascript.ui", key);
    }

    public static int getIndentWidth(IScriptProject project) {
        PreferencesLookupDelegate prefs = new PreferencesLookupDelegate(project);
        String key = "mixed".equals(prefs.getString("org.eclipse.dltk.javascript.ui", "formatter.tabulation.char")) ? "formatter.indentation.size" : "formatter.tabulation.size";
        return prefs.getInt("org.eclipse.dltk.javascript.ui", key);
    }

    public static String changeIndent(String code, int codeIndentLevel, IScriptProject project, String newIndent, String lineDelim) {
        return IndentManipulation.changeIndent(code, codeIndentLevel, JSCodeGeneration.getTabWidth(project), JSCodeGeneration.getIndentWidth(project), newIndent, lineDelim);
    }

    private static boolean isEmptyComment(String comment) {
        int begin = 0;
        int end = comment.length();
        while (begin < end && Character.isWhitespace(comment.charAt(begin))) {
            ++begin;
        }
        if (begin < end && comment.charAt(begin) == '/') {
            ++begin;
        }
        while (begin < end && Character.isWhitespace(comment.charAt(end - 1))) {
            --end;
        }
        if (begin < end && comment.charAt(end - 1) == '/') {
            --end;
        }
        while (begin < end && (Character.isWhitespace(comment.charAt(begin)) || comment.charAt(begin) == '*')) {
            ++begin;
        }
        return begin >= end;
    }
}

