/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.display.internal;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.debug.ui.display.IEvaluateConsole;
import org.eclipse.dltk.debug.ui.display.IEvaluateConsoleListener;
import org.eclipse.dltk.debug.ui.display.ScriptDisplayView;
import org.eclipse.dltk.debug.ui.display.internal.ConsoleMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.internal.console.ConsolePluginImages;
import org.eclipse.ui.internal.console.ShowConsoleAction;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IUpdate;

public class ConsoleDropDownAction
extends Action
implements IMenuCreator,
IEvaluateConsoleListener,
IUpdate {
    private ScriptDisplayView fView;
    private Menu fMenu;

    public void update() {
        this.setEnabled(this.fView.getConsoles().length > 1);
    }

    public ConsoleDropDownAction(ScriptDisplayView view) {
        this.fView = view;
        this.setText(ConsoleMessages.ConsoleDropDownAction_0);
        this.setToolTipText(ConsoleMessages.ConsoleDropDownAction_1);
        this.setImageDescriptor(ConsolePluginImages.getImageDescriptor((String)"IMG_VIEW_CONSOLE"));
        this.setMenuCreator(this);
        this.fView.addConsoleListener(this);
        this.update();
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fView = null;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        IConsole[] consoles = this.fView.getConsoles();
        IConsole current = this.fView.getConsole();
        int i = 0;
        while (i < consoles.length) {
            IConsole console = consoles[i];
            ShowConsoleAction action = new ShowConsoleAction((IConsoleView)this.fView, console);
            action.setChecked(console.equals(current));
            this.addActionToMenu(this.fMenu, (Action)action, i + 1);
            ++i;
        }
        return this.fMenu;
    }

    private void addActionToMenu(Menu parent, Action action, int accelerator) {
        if (accelerator < 10) {
            StringBuffer label = new StringBuffer();
            label.append('&');
            label.append(accelerator);
            label.append(' ');
            label.append(action.getText());
            action.setText(label.toString());
        }
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void run() {
        List<IConsole> stack;
        boolean pinned = this.fView.isPinned();
        if (pinned) {
            this.fView.setPinned(false);
        }
        if ((stack = this.fView.getConsoleStack()).size() > 1) {
            IConsole console = stack.get(1);
            this.fView.display(console);
        }
        if (pinned) {
            this.fView.setPinned(true);
        }
    }

    public void consoleAdded(IEvaluateConsole console) {
        UIJob job = new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ConsoleDropDownAction.this.update();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(10);
        job.schedule();
    }

    public void consolesRemoved(IConsole[] consoles) {
        UIJob job = new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (ConsoleDropDownAction.this.fMenu != null) {
                    ConsoleDropDownAction.this.fMenu.dispose();
                }
                ConsoleDropDownAction.this.update();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(10);
        job.schedule();
    }
}

