/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.formatter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaScriptFormatterConstants {
    public static final String FORMATTER_TAB_CHAR = "formatter.tabulation.char";
    public static final String FORMATTER_TAB_SIZE = "formatter.tabulation.size";
    public static final String FORMATTER_INDENTATION_SIZE = "formatter.indentation.size";
    public static final String LINES_PRESERVE = "lines.preserve";
    public static final String WRAP_COMMENTS = "wrap.comments";
    public static final String WRAP_COMMENTS_LENGTH = "wrap.comments.length";
    public static final String FORMATTER_PROFILES = "formatter.profiles";
    public static final String FORMATTER_ACTIVE_PROFILE = "formatter.profiles.active";
    public static final String INDENT_METHOD = "formatter.indent.function";
    public static final String INDENT_BLOCK = "formatter.indent.blocks";
    public static final String INDENT_SWITCH = "formatter.indent.switch";
    public static final String INDENT_CASE = "formatter.indent.case";
    public static final String INDENT_BREAK = "formatter.indent.break";
    public static final String INDENT_EMPTY_LINES = "formatter.indent.empty.lines";
    public static final String BRACE_METHOD = "formatter.braces.function";
    public static final String BRACE_EMPTY_FUNCTION = "formatter.braces.empty.function";
    public static final String BRACE_BLOCK = "formatter.braces.blocks";
    public static final String BRACE_SWITCH = "formatter.braces.switch";
    public static final String BRACE_CASE = "formatter.braces.case";
    public static final String BRACE_ARRAY = "formatter.braces.array";
    public static final String BRACE_EMPTY_ARRAY = "formatter.braces.empty.array";
    public static final String BRACE_EMPTY_OBJECT = "formatter.braces.empty.object";
    public static final String BRACE_SAME_LINE = "same.line";
    public static final String BRACE_NEXT_LINE = "next.line";
    public static final String BRACE_NEXT_LINE_INDENTED = "next.line.indented";
    public static final String BRACE_NEXT_LINE_ON_WRAP = "next.line.on.wrap";
    public static final String STATEMENT_NEW_LINE = "formatter.statement.new.line";
    public static final String KEEP_LINES = "formatter.keep.lines";
    public static final String NEW_LINE_IN_EMPTY_METHOD = "formatter.newlines.empty.method";
    public static final String NEW_LINE_IN_EMPTY_BLOCK = "formatter.newlines.empty.block";
    public static final String NEW_LINE_AT_EOF = "formatter.newlines.eof";
    public static final String NEW_LINE_BEFORE_ELSE_IN_IF = "formatter.newlines.else";
    public static final String NEW_LINE_BEFORE_CATCH_IN_TRY = "formatter.newlines.catch";
    public static final String NEW_LINE_BEFORE_FINALLY_IN_TRY = "formatter.newlines.finally";
    public static final String NEW_LINE_BEFORE_WHILE_IN_DO = "formatter.newlines.while";
    public static final String KEEP_THEN_ON_SAME_LINE = "formatter.samelines.then";
    public static final String KEEP_SIMPLE_IF_ON_ONE_LINE = "formatter.samelines.simpleif";
    public static final String KEEP_ELSE_IF_ON_ONE_LINE = "formatter.samelines.elseif";
    public static final String KEEP_RETURN_ON_ONE_LINE = "formatter.samelines.return";
    public static final String KEEP_THROW_ON_ONE_LINE = "formatter.samelines.throw";
    public static final String INSERT_SPACE_BEFORE_LP_IF = "formatter.insertspace.before.lp.if";
    public static final String INSERT_SPACE_AFTER_LP_IF = "formatter.insertspace.after.lp.if";
    public static final String INSERT_SPACE_BEFORE_RP_IF = "formatter.insertspace.before.rp.if";
    public static final String INSERT_SPACE_BEFORE_LP_FOR = "formatter.insertspace.before.lp.for";
    public static final String INSERT_SPACE_AFTER_LP_FOR = "formatter.insertspace.after.lp.for";
    public static final String INSERT_SPACE_BEFORE_RP_FOR = "formatter.insertspace.before.rp.for";
    public static final String INSERT_SPACE_BEFORE_LP_SWITCH = "formatter.insertspace.before.lp.switch";
    public static final String INSERT_SPACE_AFTER_LP_SWITCH = "formatter.insertspace.after.lp.switch";
    public static final String INSERT_SPACE_BEFORE_RP_SWITCH = "formatter.insertspace.before.rp.switch";
    public static final String INSERT_SPACE_BEFORE_LP_WHILE = "formatter.insertspace.before.lp.while";
    public static final String INSERT_SPACE_AFTER_LP_WHILE = "formatter.insertspace.after.lp.while";
    public static final String INSERT_SPACE_BEFORE_RP_WHILE = "formatter.insertspace.before.rp.while";
    public static final String INSERT_SPACE_BEFORE_LP_CALL = "formatter.insertspace.before.lp.call";
    public static final String INSERT_SPACE_AFTER_LP_CALL = "formatter.insertspace.after.lp.call";
    public static final String INSERT_SPACE_BEFORE_RP_CALL = "formatter.insertspace.before.rp.call";
    public static final String INSERT_SPACE_BEFORE_LP_EXPRESSION = "formatter.insertspace.before.lp.expression";
    public static final String INSERT_SPACE_AFTER_LP_EXPRESSION = "formatter.insertspace.after.lp.expression";
    public static final String INSERT_SPACE_BEFORE_RP_EXPRESSION = "formatter.insertspace.before.rp.expression";
    public static final String INSERT_SPACE_BEFORE_LP_FUNCTION_ARGUMENTS = "formatter.insertspace.before.lp.function";
    public static final String INSERT_SPACE_AFTER_LP_FUNCTION_ARGUMENTS = "formatter.insertspace.after.lp.function";
    public static final String INSERT_SPACE_BEFORE_RP_FUNCTION_ARGUMENTS = "formatter.insertspace.before.rp.function";
    public static final String INSERT_SPACE_BETWEEN_PARENS_FUNCTION_NO_ARGUMENTS = "formatter.insertspace.between.parents.empty";
    public static final String INSERT_SPACE_BEFORE_LP_CATCH = "formatter.insertspace.before.lp.catch";
    public static final String INSERT_SPACE_AFTER_LP_CATCH = "formatter.insertspace.after.lp.catch";
    public static final String INSERT_SPACE_BEFORE_RP_CATCH = "formatter.insertspace.before.rp.catch";
    public static final String INSERT_SPACE_BEFORE_LP_WITH = "formatter.insertspace.before.lp.with";
    public static final String INSERT_SPACE_AFTER_LP_WITH = "formatter.insertspace.after.lp.with";
    public static final String INSERT_SPACE_BEFORE_RP_WITH = "formatter.insertspace.before.rp.with";
    private static final Map<String, OptionInfo> options = new HashMap<String, OptionInfo>();
    private static final String[] names;
    private static final int STRING = 0;
    private static final int BOOLEAN = 1;
    private static final int INT = 2;

    static {
        JavaScriptFormatterConstants.registerOptions();
        ArrayList keys = new ArrayList(options.keySet());
        Collections.sort(keys);
        names = keys.toArray(new String[keys.size()]);
    }

    private static void registerOptions() {
        JavaScriptFormatterConstants.registerBooleanOption(STATEMENT_NEW_LINE, true);
        JavaScriptFormatterConstants.registerStringOption(FORMATTER_TAB_CHAR, "tab");
        JavaScriptFormatterConstants.registerIntegerOption(FORMATTER_TAB_SIZE, 4);
        JavaScriptFormatterConstants.registerIntegerOption(FORMATTER_INDENTATION_SIZE, 2);
        JavaScriptFormatterConstants.registerIntegerOption(LINES_PRESERVE, -1);
        JavaScriptFormatterConstants.registerBooleanOption(WRAP_COMMENTS, true);
        JavaScriptFormatterConstants.registerIntegerOption(WRAP_COMMENTS_LENGTH, 80);
        JavaScriptFormatterConstants.registerBooleanOption(INDENT_METHOD, true);
        JavaScriptFormatterConstants.registerBooleanOption(INDENT_BLOCK, true);
        JavaScriptFormatterConstants.registerBooleanOption(INDENT_SWITCH, false);
        JavaScriptFormatterConstants.registerBooleanOption(INDENT_CASE, true);
        JavaScriptFormatterConstants.registerBooleanOption(INDENT_BREAK, true);
        JavaScriptFormatterConstants.registerBooleanOption(INDENT_EMPTY_LINES, true);
        JavaScriptFormatterConstants.registerStringOption(BRACE_METHOD, BRACE_SAME_LINE);
        JavaScriptFormatterConstants.registerStringOption(BRACE_BLOCK, BRACE_SAME_LINE);
        JavaScriptFormatterConstants.registerStringOption(BRACE_SWITCH, BRACE_SAME_LINE);
        JavaScriptFormatterConstants.registerStringOption(BRACE_CASE, BRACE_SAME_LINE);
        JavaScriptFormatterConstants.registerStringOption(BRACE_ARRAY, BRACE_SAME_LINE);
        JavaScriptFormatterConstants.registerBooleanOption(BRACE_EMPTY_ARRAY, true);
        JavaScriptFormatterConstants.registerBooleanOption(BRACE_EMPTY_FUNCTION, false);
        JavaScriptFormatterConstants.registerBooleanOption(BRACE_EMPTY_OBJECT, false);
        JavaScriptFormatterConstants.registerBooleanOption(NEW_LINE_IN_EMPTY_METHOD, false);
        JavaScriptFormatterConstants.registerBooleanOption(NEW_LINE_IN_EMPTY_BLOCK, false);
        JavaScriptFormatterConstants.registerBooleanOption(NEW_LINE_AT_EOF, true);
        JavaScriptFormatterConstants.registerBooleanOption(NEW_LINE_BEFORE_ELSE_IN_IF, false);
        JavaScriptFormatterConstants.registerBooleanOption(NEW_LINE_BEFORE_CATCH_IN_TRY, false);
        JavaScriptFormatterConstants.registerBooleanOption(NEW_LINE_BEFORE_FINALLY_IN_TRY, false);
        JavaScriptFormatterConstants.registerBooleanOption(NEW_LINE_BEFORE_WHILE_IN_DO, false);
        JavaScriptFormatterConstants.registerBooleanOption(KEEP_THEN_ON_SAME_LINE, false);
        JavaScriptFormatterConstants.registerBooleanOption(KEEP_SIMPLE_IF_ON_ONE_LINE, false);
        JavaScriptFormatterConstants.registerBooleanOption(KEEP_ELSE_IF_ON_ONE_LINE, true);
        JavaScriptFormatterConstants.registerBooleanOption(KEEP_RETURN_ON_ONE_LINE, false);
        JavaScriptFormatterConstants.registerBooleanOption(KEEP_THROW_ON_ONE_LINE, false);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_BEFORE_LP_IF, true);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_AFTER_LP_IF, false);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_BEFORE_RP_IF, false);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_BEFORE_LP_FOR, true);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_AFTER_LP_FOR, false);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_BEFORE_RP_FOR, false);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_BEFORE_LP_SWITCH, true);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_AFTER_LP_SWITCH, false);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_BEFORE_RP_SWITCH, false);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_BEFORE_LP_WHILE, true);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_AFTER_LP_WHILE, false);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_BEFORE_RP_WHILE, false);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_BEFORE_LP_CALL, false);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_AFTER_LP_CALL, false);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_BEFORE_RP_CALL, false);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_BEFORE_LP_EXPRESSION, true);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_AFTER_LP_EXPRESSION, false);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_BEFORE_RP_EXPRESSION, false);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_BEFORE_LP_FUNCTION_ARGUMENTS, false);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_AFTER_LP_FUNCTION_ARGUMENTS, false);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_BEFORE_RP_FUNCTION_ARGUMENTS, false);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_BETWEEN_PARENS_FUNCTION_NO_ARGUMENTS, false);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_BEFORE_LP_CATCH, true);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_AFTER_LP_CATCH, false);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_BEFORE_RP_CATCH, false);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_BEFORE_LP_WITH, true);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_AFTER_LP_WITH, false);
        JavaScriptFormatterConstants.registerBooleanOption(INSERT_SPACE_BEFORE_RP_WITH, false);
    }

    private static void registerIntegerOption(String name, int defaultValue) {
        JavaScriptFormatterConstants.internalRegisterOption(name, 2, defaultValue);
    }

    private static void registerStringOption(String name, String defaultValue) {
        JavaScriptFormatterConstants.internalRegisterOption(name, 0, defaultValue);
    }

    private static void registerBooleanOption(String name, boolean defaultValue) {
        JavaScriptFormatterConstants.internalRegisterOption(name, 1, defaultValue);
    }

    private static void internalRegisterOption(String name, int type, Object defaultValue) {
        options.put(name, new OptionInfo(type, defaultValue));
    }

    public static boolean isDefined(String name) {
        return options.containsKey(name);
    }

    public static boolean isBoolean(String name) {
        if (!JavaScriptFormatterConstants.isDefined(name)) {
            return false;
        }
        return JavaScriptFormatterConstants.options.get((Object)name).type == 1;
    }

    public static boolean isInteger(String name) {
        if (!JavaScriptFormatterConstants.isDefined(name)) {
            return false;
        }
        return JavaScriptFormatterConstants.options.get((Object)name).type == 2;
    }

    public static boolean isString(String name) {
        if (!JavaScriptFormatterConstants.isDefined(name)) {
            return false;
        }
        return JavaScriptFormatterConstants.options.get((Object)name).type == 0;
    }

    public static String[] getNames() {
        return names;
    }

    public static Object getDefaultValue(String name) {
        if (!JavaScriptFormatterConstants.isDefined(name)) {
            return null;
        }
        return JavaScriptFormatterConstants.options.get((Object)name).defaultValue;
    }

    public static Map<String, Object> getDefaults() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Map.Entry<String, OptionInfo> entry : options.entrySet()) {
            values.put(entry.getKey(), entry.getValue().defaultValue);
        }
        return values;
    }

    private static final class OptionInfo {
        int type;
        Object defaultValue;

        public OptionInfo(int type, Object defaultValue) {
            this.type = type;
            this.defaultValue = defaultValue;
        }
    }
}

