/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.util;

import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISearchPatternProcessor;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.TypeNameMatch;
import org.eclipse.dltk.internal.corext.util.SearchUtils;
import org.eclipse.dltk.internal.corext.util.Strings;
import org.eclipse.dltk.internal.corext.util.TypeInfoRequestorAdapter;
import org.eclipse.dltk.internal.ui.util.StringMatcher;
import org.eclipse.dltk.ui.dialogs.ITypeInfoFilterExtension;

public class TypeInfoFilter {
    private String fText;
    private final IDLTKSearchScope fSearchScope;
    private boolean fIsWorkspaceScope;
    private int fElementKind;
    private ITypeInfoFilterExtension fFilterExtension;
    private TypeInfoRequestorAdapter fAdapter = new TypeInfoRequestorAdapter();
    private PatternMatcher fPackageMatcher;
    private PatternMatcher fNameMatcher;
    private static final int TYPE_MODIFIERS = 0;

    public TypeInfoFilter(String text, IDLTKSearchScope scope, int elementKind, ITypeInfoFilterExtension extension) {
        this.fText = text;
        this.fSearchScope = scope;
        IDLTKLanguageToolkit toolkit = scope.getLanguageToolkit();
        this.fIsWorkspaceScope = this.fSearchScope.equals(SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)toolkit));
        this.fElementKind = elementKind;
        this.fFilterExtension = extension;
        ISearchPatternProcessor processor = DLTKLanguageManager.getSearchPatternProcessor((IDLTKLanguageToolkit)toolkit, (boolean)true);
        ISearchPatternProcessor.ITypePattern pattern = processor.parseType(text);
        String simpleName = pattern.getSimpleName();
        if (simpleName.length() == 0) {
            simpleName = "*";
        }
        this.fNameMatcher = new PatternMatcher(simpleName, true);
        if (pattern.getQualification() != null) {
            this.fPackageMatcher = new PatternMatcher(this.evaluatePackagePattern(pattern.getQualification()), true);
        }
    }

    private String evaluatePackagePattern(String s) {
        StringBuilder buf = new StringBuilder();
        boolean hasWildCard = false;
        int len = s.length();
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            if (ch == '$') {
                if (!hasWildCard) {
                    buf.append('*');
                }
                hasWildCard = false;
            } else if (ch == '*' || ch == '?') {
                hasWildCard = true;
            }
            buf.append(ch);
            ++i;
        }
        if (!hasWildCard) {
            if (len == 0) {
                buf.append('?');
            }
            buf.append('*');
        }
        return buf.toString();
    }

    public String getText() {
        return this.fText;
    }

    public boolean isSubFilter(String text) {
        if (!this.fText.startsWith(text)) {
            return false;
        }
        return this.fText.indexOf(46, text.length()) == -1;
    }

    public boolean isCamelCasePattern() {
        return this.fNameMatcher.getMatchKind() == 128;
    }

    public String getPackagePattern() {
        if (this.fPackageMatcher == null) {
            return null;
        }
        return this.fPackageMatcher.getPattern();
    }

    public String getNamePattern() {
        return this.fNameMatcher.getPattern();
    }

    public int getSearchFlags() {
        return this.fNameMatcher.getMatchKind();
    }

    public int getPackageFlags() {
        if (this.fPackageMatcher == null) {
            return 0;
        }
        return this.fPackageMatcher.getMatchKind();
    }

    public boolean matchesRawNamePattern(TypeNameMatch type) {
        return Strings.startsWithIgnoreCase(type.getSimpleTypeName(), this.fNameMatcher.getPattern());
    }

    public boolean matchesCachedResult(TypeNameMatch type) {
        if (!this.matchesPackage(type) || !this.matchesFilterExtension(type)) {
            return false;
        }
        return this.matchesName(type);
    }

    public boolean matchesHistoryElement(TypeNameMatch type) {
        if (!(this.matchesPackage(type) && this.matchesModifiers(type) && this.matchesScope(type) && this.matchesFilterExtension(type))) {
            return false;
        }
        return this.matchesName(type);
    }

    public boolean matchesFilterExtension(TypeNameMatch type) {
        if (this.fFilterExtension == null) {
            return true;
        }
        this.fAdapter.setMatch(type);
        return this.fFilterExtension.select(this.fAdapter);
    }

    private boolean matchesName(TypeNameMatch type) {
        return this.fNameMatcher.matches(type.getSimpleTypeName());
    }

    private boolean matchesPackage(TypeNameMatch type) {
        if (this.fPackageMatcher == null) {
            return true;
        }
        return this.fPackageMatcher.matches(type.getTypeContainerName());
    }

    private boolean matchesScope(TypeNameMatch type) {
        if (this.fIsWorkspaceScope) {
            return true;
        }
        return this.fSearchScope.encloses((IModelElement)type.getType());
    }

    private boolean matchesModifiers(TypeNameMatch type) {
        if (this.fElementKind == 0) {
            return true;
        }
        type.getModifiers();
        boolean modifiers = false;
        switch (this.fElementKind) {
            case 0: {
                return !modifiers;
            }
        }
        return false;
    }

    private static class PatternMatcher {
        private String fPattern;
        private int fMatchKind;
        private StringMatcher fStringMatcher;
        private static final char END_SYMBOL = '<';
        private static final char ANY_STRING = '*';
        private static final char BLANK = ' ';

        public PatternMatcher(String pattern, boolean ignoreCase) {
            this(pattern, 131);
        }

        public PatternMatcher(String pattern, int allowedModes) {
            this.initializePatternAndMatchKind(pattern);
            this.fMatchKind &= allowedModes;
            if (this.fMatchKind == 2) {
                this.fStringMatcher = new StringMatcher(this.fPattern, true, false);
            }
        }

        public String getPattern() {
            return this.fPattern;
        }

        public int getMatchKind() {
            return this.fMatchKind;
        }

        public boolean matches(String text) {
            switch (this.fMatchKind) {
                case 2: {
                    return this.fStringMatcher.match(text);
                }
                case 0: {
                    return this.fPattern.equalsIgnoreCase(text);
                }
                case 128: {
                    if (!SearchPattern.camelCaseMatch((String)this.fPattern, (String)text)) break;
                    return true;
                }
            }
            return Strings.startsWithIgnoreCase(text, this.fPattern);
        }

        private void initializePatternAndMatchKind(String pattern) {
            int length = pattern.length();
            if (length == 0) {
                this.fMatchKind = 0;
                this.fPattern = pattern;
                return;
            }
            char last = pattern.charAt(length - 1);
            if (pattern.indexOf(42) != -1 || pattern.indexOf(63) != -1) {
                this.fMatchKind = 2;
                switch (last) {
                    case '<': {
                        this.fPattern = pattern.substring(0, length - 1);
                        break;
                    }
                    case ' ': {
                        this.fPattern = pattern.trim();
                        break;
                    }
                    case '*': {
                        this.fPattern = pattern;
                        break;
                    }
                    default: {
                        this.fPattern = String.valueOf(pattern) + '*';
                    }
                }
                return;
            }
            if (last == '<') {
                this.fMatchKind = 0;
                this.fPattern = pattern.substring(0, length - 1);
                return;
            }
            if (last == ' ') {
                this.fMatchKind = 0;
                this.fPattern = pattern.trim();
                return;
            }
            if (SearchUtils.isCamelCasePattern((String)pattern)) {
                this.fMatchKind = 128;
                this.fPattern = pattern;
                return;
            }
            this.fMatchKind = 1;
            this.fPattern = pattern;
        }
    }
}

