/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.parser.ast.expressions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.utils.CorePrinter;

public class PythonLambdaExpression
extends Expression {
    private List fArguments;
    private Expression fBodyExpressions;

    public PythonLambdaExpression(DLTKToken t, List arguments, Expression body) {
        super(t);
        if (body != null) {
            this.setEnd(body.sourceEnd());
        }
        this.fArguments = arguments;
        this.fBodyExpressions = body;
    }

    public List getArguments() {
        return this.fArguments;
    }

    public Expression getBodyExpression() {
        return this.fBodyExpressions;
    }

    public int getKind() {
        return 38011;
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit((Expression)this)) {
            if (this.fArguments != null) {
                Iterator i = this.fArguments.iterator();
                while (i.hasNext()) {
                    Argument arg = (Argument)i.next();
                    arg.traverse(pVisitor);
                }
            }
            if (this.fBodyExpressions != null) {
                this.fBodyExpressions.traverse(pVisitor);
            }
            pVisitor.endvisit((Expression)this);
        }
    }

    public void printNode(CorePrinter output) {
        output.formatPrintLn("lambda ");
        if (this.fArguments != null) {
            boolean first = true;
            Iterator i = this.fArguments.iterator();
            while (i.hasNext()) {
                Argument arg = (Argument)i.next();
                if (first) {
                    first = false;
                } else {
                    output.formatPrintLn(", ");
                }
                arg.printNode(output);
            }
        }
        output.formatPrintLn(":");
        if (this.fBodyExpressions != null) {
            this.fBodyExpressions.printNode(output);
        }
    }
}

